/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.jamd;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.unrealdinnerbone.jamd.ConfigCodec;
import com.unrealdinnerbone.jamd.JAMD;
import com.unrealdinnerbone.jamd.OresCodec;
import com.unrealdinnerbone.jamd.api.FeatureTypeRegistry;
import com.unrealdinnerbone.jamd.block.base.PortalTileEntity;
import com.unrealdinnerbone.trenzalore.api.registry.RegistryEntry;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldType {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = LoggerFactory.getLogger(WorldType.class);
    public static final List<WorldType> TYPES = new ArrayList<WorldType>();
    private final String name;
    private final KeySet key;
    private final RegistryEntry<Block> block;
    private final RegistryEntry<BlockItem> item;
    private final RegistryEntry<BlockEntityType<PortalTileEntity>> blockEntity;
    private final Path configPath;
    private final TagKey<Biome> biomeTag;

    public WorldType(String name, RegistryEntry<Block> block, RegistryEntry<BlockItem> item, RegistryEntry<BlockEntityType<PortalTileEntity>> blockEntity, TagKey<Biome> biomeTag) {
        this.name = name;
        this.key = KeySet.of(new ResourceLocation("jamd", name));
        this.block = block;
        this.item = item;
        this.blockEntity = blockEntity;
        this.biomeTag = biomeTag;
        this.configPath = JAMD.CONFIG_FOLDER.resolve(name + ".json");
        TYPES.add(this);
    }

    public RegistryEntry<Block> getBlock() {
        return this.block;
    }

    public RegistryEntry<BlockEntityType<PortalTileEntity>> getBlockEntity() {
        return this.blockEntity;
    }

    public RegistryEntry<BlockItem> getItem() {
        return this.item;
    }

    public KeySet getKey() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorldType worldType = (WorldType)o;
        return Objects.equals(this.name, worldType.name);
    }

    public String getName() {
        return this.name;
    }

    public TagKey<Biome> getBiomeTag() {
        return this.biomeTag;
    }

    public Path getConfigPath() {
        return this.configPath;
    }

    public void exportIfNotExist(MinecraftServer server) throws IllegalStateException, IOException {
        if (!Files.exists(this.configPath, new LinkOption[0])) {
            this.export(server);
        }
    }

    public void export(MinecraftServer server) throws IllegalStateException, IOException {
        ArrayList<OresCodec> oresCodecs = new ArrayList<OresCodec>();
        List<PlacedFeature> placedFeatures = this.getFeatures(server);
        for (PlacedFeature placedFeature : placedFeatures) {
            DataResult result;
            DataResult json;
            List placementModifiers = placedFeature.f_191776_();
            for (PlacementModifier modifier : placementModifiers) {
                DataResult dataResult = PlacementModifier.f_191842_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)modifier);
                Optional result2 = dataResult.result();
                if (!result2.isEmpty()) continue;
                LOGGER.error("Failed to encode: {}", (Object)((DataResult.PartialResult)dataResult.error().get()).message());
            }
            if (!placedFeature.f_191775_().m_203565_(OreFeatures.f_195064_) && (json = PlacedFeature.f_191772_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)placedFeature)).result().isPresent()) {
                try {
                    JsonElement jsonElement = (JsonElement)json.result().get();
                    JsonObject jsonObject = jsonElement.getAsJsonObject();
                    JsonObject feature = jsonObject.getAsJsonObject("feature");
                    String featureType = GsonHelper.m_13906_((JsonObject)feature, (String)"type");
                    FeatureTypeRegistry.getFeatureType(featureType).ifPresent(iFeatureTypeCompact -> {
                        try {
                            oresCodecs.add(iFeatureTypeCompact.getOreCodec(GsonHelper.m_13930_((JsonObject)feature, (String)"config"), placementModifiers));
                        }
                        catch (Exception e) {
                            LOGGER.error("Failed to parse ore", (Throwable)e);
                        }
                    });
                }
                catch (JsonSyntaxException e) {
                    LOGGER.error("Skipping ore", (Throwable)e);
                }
            }
            if ((result = ConfigCodec.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new ConfigCodec(1, oresCodecs))).result().isPresent()) {
                if (!Files.exists(JAMD.CONFIG_FOLDER, new LinkOption[0])) {
                    Files.createDirectories(JAMD.CONFIG_FOLDER, new FileAttribute[0]);
                }
                Files.writeString(this.configPath, (CharSequence)GSON.toJson((JsonElement)result.result().get()), new OpenOption[0]);
                continue;
            }
            throw new IllegalStateException(((DataResult.PartialResult)result.error().get()).message());
        }
    }

    public List<PlacedFeature> getFeatures(MinecraftServer server) {
        ArrayList<PlacedFeature> features = new ArrayList<PlacedFeature>();
        HolderLookup.RegistryLookup biomeRegistryLookup = (HolderLookup.RegistryLookup)server.m_206579_().m_254861_(Registries.f_256952_).orElseThrow();
        for (Holder.Reference biomeReference : biomeRegistryLookup.m_214062_().toList()) {
            Set placedFeatures = (Set)((Biome)biomeReference.m_203334_()).m_47536_().f_186648_.get();
            for (PlacedFeature placedFeature : placedFeatures) {
                if (!biomeReference.m_203656_(this.biomeTag) || features.contains(placedFeature)) continue;
                features.add(placedFeature);
            }
        }
        return features;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public record KeySet(ResourceKey<Level> level, ResourceKey<DimensionType> dimensionType, ResourceKey<Biome> biome) {
        private static KeySet of(ResourceLocation id) {
            return new KeySet((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)id), (ResourceKey<DimensionType>)ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)id), (ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)id));
        }
    }
}

