/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.impl.util;

import dev.lukebemish.dynamicassetgenerator.api.compat.ConditionalInvisibleResourceProvider;
import dev.lukebemish.dynamicassetgenerator.api.compat.InvisibleResourceProvider;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InvisibleProviderUtils {
    public static final List<InvisibleResourceProvider> INVISIBLE_RESOURCE_PROVIDERS = Stream.concat(ServiceLoader.load(InvisibleResourceProvider.class).stream().map(ServiceLoader.Provider::get), ServiceLoader.load(ConditionalInvisibleResourceProvider.class).stream().map(ServiceLoader.Provider::get).filter(ConditionalInvisibleResourceProvider::isAvailable).map(ConditionalInvisibleResourceProvider::get)).toList();

    private InvisibleProviderUtils() {
    }

    public static PackResources constructPlaceholderResourcesFromProvider(final InvisibleResourceProvider provider) {
        return new PackResources(){

            @Nullable
            public IoSupplier<InputStream> m_8017_(String ... strings) {
                return null;
            }

            public IoSupplier<InputStream> m_214146_(@NotNull PackType type, @NotNull ResourceLocation location) {
                return provider.getResource(type, location);
            }

            public void m_8031_(@NotNull PackType packType, @NotNull String namespace, @NotNull String path, @NotNull PackResources.ResourceOutput resourceOutput) {
                provider.listResources(packType, namespace, path, resourceOutput);
            }

            @NotNull
            public Set<String> m_5698_(@NotNull PackType type) {
                return provider.getNamespaces(type);
            }

            @Nullable
            public <T> T m_5550_(@NotNull MetadataSectionSerializer<T> deserializer) {
                return null;
            }

            @NotNull
            public String m_5542_() {
                return "placeholder__" + provider.getClass().getName().toLowerCase(Locale.ROOT).replace('.', '_').replace('$', '_');
            }

            public void close() {
            }
        };
    }

    static {
        DynamicAssetGenerator.LOGGER.debug("Loaded invisible resource providers: {}", INVISIBLE_RESOURCE_PROVIDERS);
    }
}

