/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.impl.client;

import com.google.gson.Gson;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.cache.CacheMetaJsonOps;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.impl.CacheReference;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.client.NativeImageHelper;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.NotNull;

public final class TexSourceCache {
    private static final Map<ResourceLocation, Map<String, CacheReference<Either<NativeImage, IOException>>>> MULTI_CACHE = new ConcurrentHashMap<ResourceLocation, Map<String, CacheReference<Either<NativeImage, IOException>>>>();

    private TexSourceCache() {
    }

    @NotNull
    public static NativeImage fromCache(IoSupplier<NativeImage> supplier, TexSource source, ResourceGenerationContext context, TexSourceDataHolder data) throws IOException {
        Map cache = MULTI_CACHE.computeIfAbsent(context.getCacheName(), k -> new ConcurrentHashMap());
        try {
            CacheMetaJsonOps dataOps = new CacheMetaJsonOps();
            dataOps.putData(TexSourceDataHolder.class, data);
            String cacheKey = TexSource.CODEC.encodeStart((DynamicOps)dataOps, (Object)source).result().map(arg_0 -> ((Gson)DynamicAssetGenerator.GSON_FLAT).toJson(arg_0)).orElse(null);
            if (cacheKey == null) {
                return (NativeImage)supplier.m_247737_();
            }
            CacheReference ref = cache.containsKey(cacheKey) ? (CacheReference)cache.get(cacheKey) : new CacheReference();
            Either result = ref.calcSync(cached -> {
                if (cached == null) {
                    try {
                        NativeImage image = (NativeImage)supplier.m_247737_();
                        ref.setHeld(Either.left((Object)image));
                        NativeImage output = NativeImageHelper.of(image.m_85102_(), image.m_84982_(), image.m_85084_(), false);
                        output.m_85054_(image);
                        return Either.left((Object)output);
                    }
                    catch (IOException e) {
                        ref.setHeld(Either.right((Object)e));
                        return Either.right((Object)e);
                    }
                }
                if (cached.left().isPresent()) {
                    NativeImage image = (NativeImage)cached.left().get();
                    NativeImage output = NativeImageHelper.of(image.m_85102_(), image.m_84982_(), image.m_85084_(), false);
                    output.m_85054_(image);
                    return Either.left((Object)output);
                }
                return Either.right((Object)((IOException)cached.right().get()));
            });
            if (!cache.containsKey(cacheKey)) {
                cache.put(cacheKey, ref);
            }
            if (result.left().isPresent()) {
                return (NativeImage)result.left().get();
            }
            throw (IOException)result.right().get();
        }
        catch (RuntimeException e) {
            DynamicAssetGenerator.LOGGER.warn("Could not cache texture source; something has gone wrong with encoding or texture creation.", (Throwable)e);
            return (NativeImage)supplier.m_247737_();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset(ResourceGenerationContext context) {
        Map<ResourceLocation, Map<String, CacheReference<Either<NativeImage, IOException>>>> map = MULTI_CACHE;
        synchronized (map) {
            Map<String, CacheReference<Either<NativeImage, IOException>>> cache = MULTI_CACHE.get(context.getCacheName());
            if (cache != null) {
                cache.forEach((s, e) -> {
                    if (((Either)e.getHeld()).left().isPresent()) {
                        ((NativeImage)((Either)e.getHeld()).left().get()).close();
                    }
                });
                MULTI_CACHE.remove(context.getCacheName());
            }
        }
    }
}

