/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.impl.client;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.DynamicSpriteSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public record BuiltinDynamicSpriteSource(Map<ResourceLocation, TexSource> sources, @Nullable ResourceLocation location) implements DynamicSpriteSource
{
    public static final ResourceLocation LOCATION = new ResourceLocation("dynamic_asset_generator", "tex_sources");
    public static Codec<BuiltinDynamicSpriteSource> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, TexSource.CODEC).fieldOf("sources").forGetter(BuiltinDynamicSpriteSource::sources), (App)ResourceLocation.f_135803_.optionalFieldOf("location").forGetter(s -> Optional.ofNullable(s.location()))).apply((Applicative)i, (sources, location) -> new BuiltinDynamicSpriteSource((Map<ResourceLocation, TexSource>)sources, location.orElse(null))));

    @Override
    public Map<ResourceLocation, TexSource> getSources(ResourceGenerationContext context, ResourceManager resourceManager) {
        HashMap<ResourceLocation, TexSource> outSources = new HashMap<ResourceLocation, TexSource>(this.sources());
        if (this.location != null) {
            resourceManager.m_214159_(this.location.m_135827_() + "/" + this.location.m_135815_(), rl -> rl.m_135815_().endsWith(".json")).forEach((rl, resource) -> {
                try (BufferedReader reader = resource.m_215508_();){
                    JsonElement json = (JsonElement)DynamicAssetGenerator.GSON.fromJson((Reader)reader, JsonElement.class);
                    DataResult result = TexSource.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
                    result.result().ifPresent(texSource -> {
                        ResourceLocation sourceLocation = new ResourceLocation(rl.m_135827_(), rl.m_135815_().substring(0, rl.m_135815_().length() - 5));
                        outSources.put(sourceLocation, (TexSource)texSource);
                    });
                    result.error().ifPresent(partial -> DynamicAssetGenerator.LOGGER.error("Failed to load tex source json for " + this.location + ": " + rl + ": " + partial.message()));
                }
                catch (IOException e) {
                    DynamicAssetGenerator.LOGGER.error("Failed to load tex source json for " + this.location + ": " + rl, (Throwable)e);
                }
            });
        }
        return outSources;
    }

    @Override
    public ResourceLocation getLocation() {
        return LOCATION;
    }
}

