/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.platform.Services;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;

public record ModConfig(boolean cacheAssets, boolean cacheData, int paletteForceClusteringCutoff) {
    public static final Codec<ModConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("cache_assets").forGetter(ModConfig::cacheAssets), (App)Codec.BOOL.fieldOf("cache_data").forGetter(ModConfig::cacheData), (App)Codec.INT.fieldOf("palette_extraction_force_clustering_cutoff").forGetter(ModConfig::paletteForceClusteringCutoff)).apply((Applicative)instance, ModConfig::new));
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().create();
    public static final Path FULL_PATH = Services.PLATFORM.getConfigFolder().resolve("dynamic_asset_generator.json");

    private static ModConfig load() {
        ModConfig config = ModConfig.getDefault();
        try {
            ModConfig.checkExistence();
            JsonObject json = (JsonObject)GSON.fromJson((Reader)Files.newBufferedReader(FULL_PATH), JsonObject.class);
            Either either = CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).get();
            Optional left = either.left();
            if (left.isPresent()) {
                config = (ModConfig)left.get();
            } else {
                DynamicAssetGenerator.LOGGER.error("Config is in the wrong format! An attempt to load with this config would crash. Using default config instead...");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return config;
    }

    public static ModConfig get() {
        return ModConfig.load();
    }

    private static void checkExistence() throws IOException {
        if (!Files.exists(FULL_PATH.getParent(), new LinkOption[0])) {
            Files.createDirectories(FULL_PATH.getParent(), new FileAttribute[0]);
        }
        if (!Files.exists(FULL_PATH, new LinkOption[0])) {
            Files.createFile(FULL_PATH, new FileAttribute[0]);
            try {
                ModConfig config = ModConfig.getDefault();
                BufferedWriter writer = Files.newBufferedWriter(FULL_PATH, new OpenOption[0]);
                JsonElement json = (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)config).getOrThrow(false, e -> {});
                GSON.toJson(json, (Appendable)writer);
                ((Writer)writer).flush();
                ((Writer)writer).close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    private static ModConfig getDefault() {
        return new ModConfig(false, false, 1000000);
    }
}

