/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.lukebemish.dynamicassetgenerator.api.PathAwareInputStreamSource;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonResourceGeneratorReader
implements PathAwareInputStreamSource {
    private final Map<ResourceLocation, ResourceGenerator> map = new HashMap<ResourceLocation, ResourceGenerator>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public JsonResourceGeneratorReader(Map<ResourceLocation, String> map) {
        map.forEach((rl, str) -> {
            try {
                ResourceGenerator json = JsonResourceGeneratorReader.fromJson(str);
                if (json != null && json.getLocations().size() > 0) {
                    json.getLocations().forEach(localRl -> this.map.put((ResourceLocation)localRl, json));
                }
            }
            catch (RuntimeException e) {
                DynamicAssetGenerator.LOGGER.error("Could not read json source at {}\n", rl, (Object)e);
            }
        });
    }

    @Nullable
    static ResourceGenerator fromJson(String json) {
        JsonObject jsonObject = (JsonObject)GSON.fromJson(json, JsonObject.class);
        return (ResourceGenerator)ResourceGenerator.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow(false, s -> {});
    }

    @Override
    public IoSupplier<InputStream> get(ResourceLocation outRl, ResourceGenerationContext context) {
        ResourceGenerator json = this.map.get(outRl);
        if (json != null) {
            return json.get(outRl, context);
        }
        return null;
    }

    @Override
    @NotNull
    public Set<ResourceLocation> getLocations() {
        return this.map.keySet();
    }
}

