/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.impl;

import dev.lukebemish.dynamicassetgenerator.api.ResourceCache;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneratedPackResources
implements PackResources {
    private final ResourceCache cache;
    private Map<ResourceLocation, IoSupplier<InputStream>> streams;

    public GeneratedPackResources(ResourceCache cache) {
        this.cache = cache;
        cache.reset();
    }

    public boolean m_246538_() {
        return true;
    }

    private Map<ResourceLocation, IoSupplier<InputStream>> getStreams() {
        if (this.streams == null) {
            this.streams = this.cache.getResources();
        }
        return this.streams;
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... strings) {
        return null;
    }

    @Nullable
    public IoSupplier<InputStream> m_214146_(@NotNull PackType packType, @NotNull ResourceLocation location) {
        if (packType == this.cache.getPackType() && this.getStreams().containsKey(location)) {
            return this.getStreams().get(location);
        }
        return null;
    }

    public void m_8031_(@NotNull PackType packType, @NotNull String namespace, @NotNull String directory, @NotNull PackResources.ResourceOutput resourceOutput) {
        if (packType == this.cache.getPackType()) {
            for (ResourceLocation key : this.getStreams().keySet()) {
                if (!key.m_135815_().startsWith(directory) || !key.m_135827_().equals(namespace) || this.getStreams().get(key) == null) continue;
                resourceOutput.accept((Object)key, this.getStreams().get(key));
            }
        }
    }

    @NotNull
    public Set<String> m_5698_(@NotNull PackType type) {
        HashSet<String> namespaces = new HashSet<String>();
        if (type == this.cache.getPackType()) {
            for (ResourceLocation key : this.getStreams().keySet()) {
                namespaces.add(key.m_135827_());
            }
        }
        return namespaces;
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> deserializer) {
        if (deserializer.m_7991_().equals("pack")) {
            return (T)DynamicAssetGenerator.fromCache(this.cache);
        }
        return null;
    }

    @NotNull
    public String m_5542_() {
        return "dynamic_asset_generator:" + this.cache.getName().toString();
    }

    public void close() {
    }
}

