/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceCache;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerator;
import dev.lukebemish.dynamicassetgenerator.api.generators.DummyGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.BuiltinDataResourceCache;
import dev.lukebemish.dynamicassetgenerator.impl.ModConfig;
import dev.lukebemish.dynamicassetgenerator.impl.platform.Services;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DynamicAssetGenerator {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().create();
    public static final Gson GSON_FLAT = new GsonBuilder().setLenient().create();
    public static final String MOD_ID = "dynamic_asset_generator";
    public static final Logger LOGGER = LogManager.getLogger((String)"dynamic_asset_generator");
    private static ModConfig configs;
    public static final boolean TIME_RESOURCES;
    public static final Map<ResourceLocation, PackInfo> CACHES;

    public static PackMetadataSection fromCache(ResourceCache cache) {
        return new PackMetadataSection((Component)Component.m_237113_((String)("Dynamic Asset Generator: " + cache.getName())), SharedConstants.m_183709_().m_264084_(cache.getPackType()));
    }

    public static ModConfig getConfig() {
        if (configs == null) {
            configs = ModConfig.get();
        }
        return configs;
    }

    public static void init() {
        ResourceGenerator.register(new ResourceLocation(MOD_ID, "dummy"), DummyGenerator.CODEC);
        if (TIME_RESOURCES) {
            LOGGER.info("dynamicassetgenerator.time_resources is true. Dynamic Asset Generator will time resource generation during this run!");
            try {
                Files.deleteIfExists(Services.PLATFORM.getModDataFolder().resolve("times.log"));
            }
            catch (IOException e) {
                LOGGER.error("Issue deleting times.log; you might be able to ignore this", (Throwable)e);
            }
        }
        ResourceGenerator.register(new ResourceLocation(MOD_ID, "dummy"), DummyGenerator.CODEC);
        ResourceCache.register(new BuiltinDataResourceCache(new ResourceLocation(MOD_ID, "builtin_data")), Pack.Position.TOP);
    }

    public static void registerCache(ResourceLocation id, ResourceCache cache, Pack.Position position) {
        CACHES.put(id, new PackInfo(cache, position));
    }

    static {
        TIME_RESOURCES = "true".equals(System.getProperty("dynamicassetgenerator.time_resources"));
        CACHES = new HashMap<ResourceLocation, PackInfo>();
    }

    public record PackInfo(ResourceCache cache, Pack.Position position) {
    }
}

