/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.impl;

import dev.lukebemish.dynamicassetgenerator.api.DataResourceCache;
import dev.lukebemish.dynamicassetgenerator.api.ServerPrePackRepository;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.JsonResourceGeneratorReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;

public class BuiltinDataResourceCache
extends DataResourceCache {
    public BuiltinDataResourceCache(ResourceLocation name) {
        super(name);
        this.planSource(() -> new JsonResourceGeneratorReader(BuiltinDataResourceCache.getSourceJsons()));
    }

    static Map<ResourceLocation, String> getSourceJsons() {
        HashMap<ResourceLocation, String> rls = new HashMap<ResourceLocation, String>();
        HashMap<ResourceLocation, IoSupplier> available = new HashMap<ResourceLocation, IoSupplier>();
        for (PackResources r : ServerPrePackRepository.getResources()) {
            if (r.m_5542_().startsWith("dynamic_asset_generator:")) continue;
            for (String namespace : r.m_5698_(PackType.SERVER_DATA)) {
                r.m_8031_(PackType.SERVER_DATA, namespace, "dynamic_asset_generator", (rl, streamSupplier) -> {
                    if (rl.m_135815_().endsWith(".json") && streamSupplier != null) {
                        available.put((ResourceLocation)rl, (IoSupplier)streamSupplier);
                    }
                });
            }
        }
        available.forEach((rl, streamSupplier) -> {
            try (InputStream stream = (InputStream)streamSupplier.m_247737_();){
                byte[] bytes = stream.readAllBytes();
                String json = new String(bytes, StandardCharsets.UTF_8);
                rls.put((ResourceLocation)rl, json);
            }
            catch (IOException e) {
                DynamicAssetGenerator.LOGGER.error("Error reading source json: " + rl, (Throwable)e);
            }
        });
        return rls;
    }
}

