/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.impl;

import dev.lukebemish.dynamicassetgenerator.api.ResourceCache;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.platform.Services;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.resources.ResourceLocation;

public class Benchmarking {
    private static final boolean[] LOGGED = new boolean[2];

    public static void recordTime(ResourceCache cache, ResourceLocation location, long time) {
        block16: {
            Path file;
            if (!Files.exists(Services.PLATFORM.getModDataFolder(), new LinkOption[0])) {
                try {
                    Files.createDirectories(Services.PLATFORM.getModDataFolder(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    if (!LOGGED[0]) {
                        DynamicAssetGenerator.LOGGER.error("Issue creating mod data folder", (Throwable)e);
                        Benchmarking.LOGGED[0] = true;
                    }
                    return;
                }
            }
            if (!Files.exists(file = Services.PLATFORM.getModDataFolder().resolve("times.log"), new LinkOption[0])) {
                try {
                    Files.createFile(file, new FileAttribute[0]);
                }
                catch (IOException e) {
                    if (!LOGGED[1]) {
                        DynamicAssetGenerator.LOGGER.error("Issue writing to times.log", (Throwable)e);
                        Benchmarking.LOGGED[1] = true;
                    }
                    return;
                }
            }
            try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, StandardOpenOption.APPEND);){
                writer.write(cache.getName() + " " + location + " " + time + "\n");
            }
            catch (IOException e) {
                if (LOGGED[1]) break block16;
                DynamicAssetGenerator.LOGGER.error("Issue writing to times.log", (Throwable)e);
                Benchmarking.LOGGED[1] = true;
            }
        }
    }
}

