/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.util;

import com.mojang.datafixers.util.Pair;
import net.minecraft.resources.ResourceLocation;

public final class LocationUtils {
    private LocationUtils() {
    }

    public static ResourceLocation withPrefix(ResourceLocation location, String prefix) {
        if (prefix.isEmpty()) {
            return location;
        }
        return new ResourceLocation(location.m_135827_(), prefix + "/" + location.m_135815_());
    }

    public static ResourceLocation withExtension(ResourceLocation location, String extension) {
        if (extension.isEmpty()) {
            return location;
        }
        return new ResourceLocation(location.m_135827_(), location.m_135815_() + "." + extension);
    }

    public static Pair<String, ResourceLocation> separatePrefix(ResourceLocation location) {
        String[] parts = location.m_135815_().split("/", 2);
        if (parts.length == 1) {
            return Pair.of((Object)"", (Object)location);
        }
        return new Pair((Object)parts[0], (Object)new ResourceLocation(location.m_135827_(), parts[1]));
    }

    public static Pair<String, ResourceLocation> separateExtension(ResourceLocation location) {
        int index = location.m_135815_().lastIndexOf(46);
        if (index == -1) {
            return Pair.of((Object)"", (Object)location);
        }
        return new Pair((Object)location.m_135815_().substring(index + 1), (Object)new ResourceLocation(location.m_135827_(), location.m_135815_().substring(0, index)));
    }
}

