/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.sources;

import dev.lukebemish.dynamicassetgenerator.api.PathAwareInputStreamSource;
import dev.lukebemish.dynamicassetgenerator.api.Resettable;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.NotNull;

public class TagBakery
implements PathAwareInputStreamSource,
Resettable {
    private Map<ResourceLocation, List<Supplier<Set<ResourceLocation>>>> bakedTags;
    private final List<Supplier<Map<ResourceLocation, Set<ResourceLocation>>>> tagQueue;
    private final Map<ResourceLocation, Set<ResourceLocation>> staticQueue = new HashMap<ResourceLocation, Set<ResourceLocation>>();

    public TagBakery() {
        this.tagQueue = new ArrayList<Supplier<Map<ResourceLocation, Set<ResourceLocation>>>>();
        this.tagQueue.add(() -> this.staticQueue);
    }

    public void queue(Supplier<Map<ResourceLocation, Set<ResourceLocation>>> tagSupplier) {
        this.tagQueue.add(tagSupplier);
    }

    public void queue(ResourceLocation tag, Set<ResourceLocation> entries) {
        this.staticQueue.computeIfAbsent(tag, k -> new HashSet()).addAll(entries);
    }

    public void queue(ResourceLocation tag, ResourceLocation entry) {
        this.staticQueue.computeIfAbsent(tag, k -> new HashSet()).add(entry);
    }

    public void queue(Map<ResourceLocation, Set<ResourceLocation>> tags) {
        tags.forEach((tag, entries) -> this.staticQueue.computeIfAbsent((ResourceLocation)tag, k -> new HashSet()).addAll(entries));
    }

    @Override
    public IoSupplier<InputStream> get(ResourceLocation outRl, ResourceGenerationContext context) {
        return () -> {
            this.checkTags();
            return this.build(this.bakedTags.get(outRl));
        };
    }

    private InputStream build(List<Supplier<Set<ResourceLocation>>> paths) {
        StringBuilder internal = new StringBuilder();
        ArrayList toAdd = new ArrayList();
        for (Supplier<Set<ResourceLocation>> p : paths) {
            toAdd.addAll(p.get());
        }
        toAdd.forEach(rl -> {
            if (internal.length() >= 1) {
                internal.append(",\n");
            }
            internal.append("    \"").append(rl.m_135827_()).append(":").append(rl.m_135815_()).append("\"");
        });
        String json = "{\n  \"replace\":false,\n  \"values\":[" + internal + "\n]}";
        return new ByteArrayInputStream(json.getBytes());
    }

    @Override
    @NotNull
    public Set<ResourceLocation> getLocations() {
        this.checkTags();
        return this.bakedTags.keySet();
    }

    @Override
    public void reset() {
        this.bakedTags = null;
    }

    private void checkTags() {
        if (this.bakedTags == null) {
            this.bakedTags = new HashMap<ResourceLocation, List<Supplier<Set<ResourceLocation>>>>();
            this.tagQueue.forEach(supplier -> {
                Map map = (Map)supplier.get();
                map.forEach((tag, set) -> {
                    ResourceLocation tagFile = new ResourceLocation(tag.m_135827_(), "tags/" + tag.m_135815_() + ".json");
                    List list = this.bakedTags.computeIfAbsent(tagFile, k -> new ArrayList());
                    list.add(() -> set);
                });
            });
        }
    }
}

