/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.colors.operations;

import dev.lukebemish.dynamicassetgenerator.api.colors.ColorTools;
import dev.lukebemish.dynamicassetgenerator.api.colors.operations.PointwiseOperation;
import net.minecraft.util.FastColor;

public final class ColorOperations {
    public static final PointwiseOperation.Binary<Integer> MASK = (i, m, iInBounds, mInBounds) -> {
        if (!mInBounds || !iInBounds) {
            return 0;
        }
        int maskAlpha = m & 0xFF000000;
        int oldAlpha = i & 0xFF000000;
        int newAlpha = maskAlpha * oldAlpha / 255;
        return i & 0xFFFFFF | newAlpha;
    };
    public static final PointwiseOperation.Any<Integer> OVERLAY = (colors, inBounds) -> {
        if (colors.length == 0) {
            return 0;
        }
        int color = 0;
        for (int i = 0; i < colors.length; ++i) {
            if (!inBounds[i]) continue;
            color = ColorTools.ARGB32.alphaBlend(color, colors[i]);
        }
        return color;
    };
    public static final PointwiseOperation.Any<Integer> ADD = (colors, inBounds) -> {
        if (colors.length == 0) {
            return 0;
        }
        int alpha = 0;
        int red = 0;
        int green = 0;
        int blue = 0;
        for (int i = 0; i < colors.length; ++i) {
            if (!inBounds[i]) continue;
            alpha += FastColor.ARGB32.m_13655_((int)colors[i]);
            red += FastColor.ARGB32.m_13665_((int)colors[i]);
            green += FastColor.ARGB32.m_13667_((int)colors[i]);
            blue += FastColor.ARGB32.m_13669_((int)colors[i]);
        }
        return FastColor.ARGB32.m_13660_((int)ColorTools.clamp8(alpha), (int)ColorTools.clamp8(red), (int)ColorTools.clamp8(green), (int)ColorTools.clamp8(blue));
    };
    public static final PointwiseOperation.Any<Integer> MULTIPLY = (colors, inBounds) -> {
        if (colors.length == 0) {
            return 0;
        }
        float alpha = 255.0f;
        float red = 255.0f;
        float green = 255.0f;
        float blue = 255.0f;
        for (int i = 0; i < colors.length; ++i) {
            if (!inBounds[i]) continue;
            alpha *= (float)FastColor.ARGB32.m_13655_((int)colors[i]) / 255.0f;
            red *= (float)FastColor.ARGB32.m_13665_((int)colors[i]) / 255.0f;
            green *= (float)FastColor.ARGB32.m_13667_((int)colors[i]) / 255.0f;
            blue *= (float)FastColor.ARGB32.m_13669_((int)colors[i]) / 255.0f;
        }
        alpha = Math.round(alpha);
        red = Math.round(red);
        green = Math.round(green);
        blue = Math.round(blue);
        return FastColor.ARGB32.m_13660_((int)ColorTools.clamp8((int)alpha), (int)ColorTools.clamp8((int)red), (int)ColorTools.clamp8((int)green), (int)ColorTools.clamp8((int)blue));
    };
    public static final PointwiseOperation.Unary<Integer> INVERT = (color, inBounds) -> {
        if (!inBounds) {
            return 0;
        }
        return ~color;
    };

    private ColorOperations() {
    }
}

