/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.colors.clustering;

import dev.lukebemish.dynamicassetgenerator.api.colors.ColorTools;
import dev.lukebemish.dynamicassetgenerator.api.colors.clustering.Cluster;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Clusterer {
    private final Map<Integer, Integer> colorToClusterIndex = new HashMap<Integer, Integer>();
    private final List<Cluster> clusters = new ArrayList<Cluster>();
    private final ColorTools.ConversionCache rgb2labCache = new ColorTools.ConversionCache(ColorTools.CIELAB32::fromARGB32);
    private final double cutoff;

    public Clusterer(double cutoff) {
        this.cutoff = cutoff;
    }

    public void addCluster(Cluster cluster) {
        this.clusters.add(cluster);
        IntListIterator intListIterator = cluster.getColors().iterator();
        while (intListIterator.hasNext()) {
            int color = (Integer)intListIterator.next();
            this.colorToClusterIndex.put(color, this.clusters.size() - 1);
        }
    }

    public void run() {
        int size = this.clusters.size();
        while (size > 2) {
            int xF = 0;
            int yF = 1;
            double minNon0Dist = this.clusters.get(0).dist(this.clusters.get(1), this.rgb2labCache);
            for (int x = 0; x < this.clusters.size(); ++x) {
                for (int y = 0; y < this.clusters.size(); ++y) {
                    double d;
                    if (x == y || !((d = this.clusters.get(x).dist(this.clusters.get(y), this.rgb2labCache)) < minNon0Dist)) continue;
                    minNon0Dist = d;
                    xF = x;
                    yF = y;
                }
            }
            if (!(this.cutoff < 0.0) && !(minNon0Dist < this.cutoff)) break;
            Cluster toAdd = this.clusters.get(xF);
            toAdd.merge(this.clusters.remove(yF));
            size = this.clusters.size();
        }
        int i = 0;
        for (Cluster c : this.clusters) {
            IntListIterator intListIterator = c.getColors().iterator();
            while (intListIterator.hasNext()) {
                int v = (Integer)intListIterator.next();
                this.colorToClusterIndex.put(v, i);
            }
            ++i;
        }
    }

    public int clusterCount() {
        return this.clusters.size();
    }

    public boolean areCategoriesEquivalent(int colorA, int colorB) {
        int categoryA = this.colorToClusterIndex.getOrDefault(colorA, -1);
        int categoryB = this.colorToClusterIndex.getOrDefault(colorB, -1);
        if (categoryB == -1 || categoryA == -1) {
            return false;
        }
        return categoryA == categoryB;
    }

    public int getCategory(int v) {
        return this.colorToClusterIndex.getOrDefault(v, -1);
    }

    private static double distanceToLab(int colorA, int colorB) {
        int labA = ColorTools.CIELAB32.fromARGB32(colorA);
        int labB = ColorTools.CIELAB32.fromARGB32(colorB);
        return ColorTools.CIELAB32.distance(labA, labB);
    }

    public static double minimumSpacing(Collection<Integer> integers) {
        if (integers.size() <= 1) {
            return 0.0;
        }
        double m = -1.0;
        for (int x : integers) {
            for (int y : integers) {
                double d;
                if (x == y || !((d = Clusterer.distanceToLab(x, y)) < m) && !(m < 0.0)) continue;
                m = d;
            }
        }
        return m;
    }

    public static double maximumSpacing(Collection<Integer> integers) {
        if (integers.size() <= 1) {
            return 0.0;
        }
        double m = -1.0;
        for (int x : integers) {
            for (int y : integers) {
                double d;
                if (x == y || !((d = Clusterer.distanceToLab(x, y)) > m)) continue;
                m = d;
            }
        }
        return m;
    }

    public static double averageSpacing(Collection<Integer> integers) {
        if (integers.size() <= 1) {
            return 0.0;
        }
        double m = 0.0;
        double c = 0.0;
        for (int x : integers) {
            for (int y : integers) {
                if (x == y) continue;
                m += Clusterer.distanceToLab(x, y);
                c += 1.0;
            }
        }
        return m / c;
    }
}

