/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.colors.clustering;

import dev.lukebemish.dynamicassetgenerator.api.colors.ColorTools;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.Collection;

public class Cluster {
    private final IntList colors = new IntArrayList();

    public Cluster(int color) {
        this.colors.add(color);
    }

    public Cluster(Collection<Integer> colors) {
        if (colors.isEmpty()) {
            throw new IllegalArgumentException("Attempted to create a cluster with no colors");
        }
        this.colors.addAll(colors);
    }

    public double dist(Cluster other, ColorTools.ConversionCache rgb2labCache) {
        double min = ColorTools.CIELAB32.distance(rgb2labCache.convert(this.colors.getInt(0)), rgb2labCache.convert(other.colors.getInt(0)));
        IntListIterator intListIterator = this.colors.iterator();
        while (intListIterator.hasNext()) {
            int f = (Integer)intListIterator.next();
            IntListIterator intListIterator2 = other.colors.iterator();
            while (intListIterator2.hasNext()) {
                int c = (Integer)intListIterator2.next();
                double d = ColorTools.CIELAB32.distance(rgb2labCache.convert(f), rgb2labCache.convert(c));
                if (!(d < min)) continue;
                min = d;
            }
        }
        return min;
    }

    public void merge(Cluster other) {
        this.colors.addAll(other.colors);
    }

    public IntList getColors() {
        return IntLists.unmodifiable((IntList)this.colors);
    }
}

