/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.colors;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.Comparator;
import java.util.function.IntUnaryOperator;
import net.minecraft.util.FastColor;

public final class ColorTools {
    private ColorTools() {
    }

    public static double linearize(int value) {
        double v = (float)value / 255.0f;
        if (v <= 0.04045) {
            return v / 12.92;
        }
        return Math.pow((v + 0.055) / 1.055, 2.4);
    }

    public static int delinearize(double value) {
        if (value <= 0.0031308) {
            return ColorTools.clamp8((int)(value * 12.92 * 255.0 + 0.5));
        }
        return ColorTools.clamp8((int)((1.055 * Math.pow(value, 0.4166666666666667) - 0.055) * 255.0 + 0.5));
    }

    public static int clamp8(int value) {
        return Math.min(Math.max(value, 0), 255);
    }

    public static class ConversionCache {
        private final Int2IntMap cache = new Int2IntOpenHashMap();
        private final IntUnaryOperator converter;

        public ConversionCache(IntUnaryOperator converter) {
            this.converter = converter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int convert(int color) {
            Int2IntMap int2IntMap = this.cache;
            synchronized (int2IntMap) {
                if (this.cache.containsKey(color)) {
                    return this.cache.get(color);
                }
            }
            int result = this.converter.applyAsInt(color);
            Int2IntMap int2IntMap2 = this.cache;
            synchronized (int2IntMap2) {
                if (!this.cache.containsKey(color)) {
                    this.cache.put(color, result);
                }
            }
            return result;
        }
    }

    public static class HSL32 {
        public static final Comparator<Integer> COMPARATOR = Comparator.comparingInt(HSL32::lightness);

        public static int alpha(int color) {
            return color >> 24 & 0xFF;
        }

        public static int hue(int color) {
            return color >> 16 & 0xFF;
        }

        public static int saturation(int color) {
            return color >> 8 & 0xFF;
        }

        public static int lightness(int color) {
            return color & 0xFF;
        }

        public static int fromARGB32(int color) {
            int h;
            int s;
            int r = FastColor.ARGB32.m_13665_((int)color);
            int g = FastColor.ARGB32.m_13667_((int)color);
            int b = FastColor.ARGB32.m_13669_((int)color);
            int max = Math.max(r, Math.max(g, b));
            int min = Math.min(r, Math.min(g, b));
            int l = (max + min) / 2;
            if (max == min) {
                s = 0;
                h = 0;
            } else {
                int diff = max - min;
                int n = s = l >= 128 ? diff * 255 / (510 - max - min) : diff * 255 / (max + min);
                int m = max == r ? 0 : (max == g ? 1 : 2);
                h = switch (m) {
                    case 0 -> (g - b) * 255 / diff + (g < b ? 1530 : 0);
                    case 1 -> (b - r) * 255 / diff + 510;
                    default -> (r - g) * 255 / diff + 1020;
                };
                h /= 6;
            }
            return (h & 0xFF) << 16 | (s & 0xFF) << 8 | l | FastColor.ARGB32.m_13655_((int)color) << 24;
        }

        public static int color(int hue, int lightness, int saturation) {
            return (hue & 0xFF) << 16 | (saturation & 0xFF) << 8 | lightness & 0xFF;
        }
    }

    public static final class CIELAB32 {
        public static final Comparator<Integer> COMPARATOR = Comparator.comparingInt(CIELAB32::lightness);
        private static final double XN = 0.95047;
        private static final double YN = 1.0;
        private static final double ZN = 1.08883;
        private static final double delta = 0.20689655172413793;
        private static final double delta2 = 0.04280618311533888;
        private static final double delta3 = 0.008856451679035631;

        private CIELAB32() {
        }

        public static int alpha(int color) {
            return color >> 24 & 0xFF;
        }

        public static int lightness(int color) {
            return color >> 16 & 0xFF;
        }

        public static byte a(int color) {
            return (byte)(color >> 8 & 0xFF);
        }

        public static byte b(int color) {
            return (byte)(color & 0xFF);
        }

        public static int fromARGB32(int color) {
            int r = FastColor.ARGB32.m_13665_((int)color);
            int g = FastColor.ARGB32.m_13667_((int)color);
            int b = FastColor.ARGB32.m_13669_((int)color);
            double lR = ColorTools.linearize(r);
            double lG = ColorTools.linearize(g);
            double lB = ColorTools.linearize(b);
            double x = 0.4124 * lR + 0.3576 * lG + 0.1805 * lB;
            double y = 0.2126 * lR + 0.7152 * lG + 0.0722 * lB;
            double z = 0.0193 * lR + 0.1192 * lG + 0.9505 * lB;
            double l = 116.0 * CIELAB32.cielabF(y / 1.0) - 16.0;
            double a_ = 500.0 * (CIELAB32.cielabF(x / 0.95047) - CIELAB32.cielabF(y / 1.0));
            double b_ = 200.0 * (CIELAB32.cielabF(y / 1.0) - CIELAB32.cielabF(z / 1.08883));
            return ((int)Math.round(l) & 0xFF) << 16 | ((int)Math.round(a_) & 0xFF) << 8 | (int)Math.round(b_) & 0xFF | FastColor.ARGB32.m_13655_((int)color) << 24;
        }

        public static double distance(int color1, int color2) {
            int dL = CIELAB32.lightness(color1) - CIELAB32.lightness(color2);
            int da = CIELAB32.a(color1) - CIELAB32.a(color2);
            int db = CIELAB32.b(color1) - CIELAB32.b(color2);
            return Math.sqrt(da * da + db * db + dL * dL);
        }

        private static double cielabF(double t) {
            if (t > 0.008856451679035631) {
                return Math.pow(t, 0.3333333333333333);
            }
            return t / 0.12841854934601665 + 0.13793103448275862;
        }
    }

    public static final class ABGR32 {
        public static int fromARGB32(int color) {
            return FastColor.ABGR32.m_266248_((int)FastColor.ARGB32.m_13655_((int)color), (int)FastColor.ARGB32.m_13669_((int)color), (int)FastColor.ARGB32.m_13667_((int)color), (int)FastColor.ARGB32.m_13665_((int)color));
        }
    }

    public static final class ARGB32 {
        public static final Comparator<Integer> COMPARATOR = Comparator.comparingInt(i -> FastColor.ARGB32.m_13665_((int)i) + FastColor.ARGB32.m_13667_((int)i) + FastColor.ARGB32.m_13669_((int)i));

        private ARGB32() {
        }

        public static double distance(int color1, int color2) {
            int dr = FastColor.ARGB32.m_13665_((int)color1) - FastColor.ARGB32.m_13665_((int)color2);
            int dg = FastColor.ARGB32.m_13667_((int)color1) - FastColor.ARGB32.m_13667_((int)color2);
            int db = FastColor.ARGB32.m_13669_((int)color1) - FastColor.ARGB32.m_13669_((int)color2);
            return Math.sqrt(dr * dr + dg * dg + db * db);
        }

        public static int alphaBlend(int over, int under) {
            int aUnder;
            int aOver = FastColor.ARGB32.m_13655_((int)over);
            int a = aOver + (aUnder = FastColor.ARGB32.m_13655_((int)under)) * (255 - aOver) / 255;
            if (a == 0) {
                return 0;
            }
            int r = (FastColor.ARGB32.m_13665_((int)over) * aOver + FastColor.ARGB32.m_13665_((int)under) * aUnder * (255 - aOver) / 255) / a;
            int g = (FastColor.ARGB32.m_13667_((int)over) * aOver + FastColor.ARGB32.m_13667_((int)under) * aUnder * (255 - aOver) / 255) / a;
            int b = (FastColor.ARGB32.m_13669_((int)over) * aOver + FastColor.ARGB32.m_13669_((int)under) * aUnder * (255 - aOver) / 255) / a;
            return FastColor.ARGB32.m_13660_((int)a, (int)r, (int)g, (int)b);
        }

        public static int fromABGR32(int color) {
            return FastColor.ARGB32.m_13660_((int)FastColor.ABGR32.m_266503_((int)color), (int)FastColor.ABGR32.m_266313_((int)color), (int)FastColor.ABGR32.m_266446_((int)color), (int)FastColor.ABGR32.m_266247_((int)color));
        }
    }
}

