/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.colors;

import com.mojang.serialization.Codec;
import dev.lukebemish.dynamicassetgenerator.api.colors.ColorTools;
import java.util.function.IntUnaryOperator;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum ColorEncoding implements StringRepresentable
{
    ARGB("ARGB", ColorTools.ABGR32::fromARGB32, ColorTools.ARGB32::fromABGR32),
    RGB("RGB", i -> ColorTools.ABGR32.fromARGB32(i) | 0xFF000000, i -> ColorTools.ARGB32.fromABGR32(i) | 0xFF000000),
    ABGR("ABGR", IntUnaryOperator.identity(), IntUnaryOperator.identity()),
    BGR("BGR", i -> i | 0xFF000000, i -> i | 0xFF000000);

    public final IntUnaryOperator toABGR;
    public final IntUnaryOperator fromABGR;
    private final String name;
    public static final Codec<ColorEncoding> CODEC;

    private ColorEncoding(String name, IntUnaryOperator toABGR, IntUnaryOperator fromABGR) {
        this.name = name;
        this.toABGR = toABGR;
        this.fromABGR = fromABGR;
    }

    @NotNull
    public String m_7912_() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.m_216439_(ColorEncoding::values);
    }
}

