/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.colors;

import com.mojang.serialization.Codec;
import dev.lukebemish.dynamicassetgenerator.api.colors.ColorTools;
import dev.lukebemish.dynamicassetgenerator.api.colors.operations.CachedConversionOperation;
import dev.lukebemish.dynamicassetgenerator.api.colors.operations.ChannelOperation;
import dev.lukebemish.dynamicassetgenerator.api.colors.operations.PointwiseOperation;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum Channel implements StringRepresentable
{
    RED(() -> new ChannelOperation(2)),
    GREEN(() -> new ChannelOperation(1)),
    BLUE(() -> new ChannelOperation(0)),
    ALPHA(() -> new ChannelOperation(3)),
    CIELAB_LIGHTNESS(() -> PointwiseOperation.Unary.chain(new CachedConversionOperation(new ColorTools.ConversionCache(ColorTools.CIELAB32::fromARGB32)), new ChannelOperation(2))),
    CIELAB_A(() -> PointwiseOperation.Unary.chain(new CachedConversionOperation(new ColorTools.ConversionCache(ColorTools.CIELAB32::fromARGB32)), new ChannelOperation(1))),
    CIELAB_B(() -> PointwiseOperation.Unary.chain(new CachedConversionOperation(new ColorTools.ConversionCache(ColorTools.CIELAB32::fromARGB32)), new ChannelOperation(0))),
    HSL_LIGHTNESS(() -> PointwiseOperation.Unary.chain(new CachedConversionOperation(new ColorTools.ConversionCache(ColorTools.HSL32::fromARGB32)), new ChannelOperation(2))),
    HSL_SATURATION(() -> PointwiseOperation.Unary.chain(new CachedConversionOperation(new ColorTools.ConversionCache(ColorTools.HSL32::fromARGB32)), new ChannelOperation(1))),
    HSL_HUE(() -> PointwiseOperation.Unary.chain(new CachedConversionOperation(new ColorTools.ConversionCache(ColorTools.HSL32::fromARGB32)), new ChannelOperation(0)));

    private final Supplier<PointwiseOperation.Unary<Integer>> operation;
    public static final Codec<Channel> CODEC;

    private Channel(Supplier<PointwiseOperation.Unary<Integer>> operation) {
        this.operation = operation;
    }

    public PointwiseOperation.Unary<Integer> makeOperation() {
        return this.operation.get();
    }

    @NotNull
    public String m_7912_() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    static {
        CODEC = StringRepresentable.m_216439_(Channel::values);
    }
}

