/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources.mask;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.impl.client.NativeImageHelper;
import java.util.Objects;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;

public final class InvertMask
implements TexSource {
    public static final Codec<InvertMask> CODEC = RecordCodecBuilder.create(i -> i.group((App)TexSource.CODEC.fieldOf("source").forGetter(InvertMask::getSource)).apply((Applicative)i, InvertMask::new));
    private final TexSource source;

    private InvertMask(TexSource source) {
        this.source = source;
    }

    @Override
    public Codec<? extends TexSource> codec() {
        return CODEC;
    }

    @Override
    @Nullable
    public IoSupplier<NativeImage> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        IoSupplier<NativeImage> input = this.source.getSupplier(data, context);
        if (input == null) {
            data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.source.stringify());
            return null;
        }
        return () -> {
            try (NativeImage inImg = (NativeImage)input.m_247737_();){
                int width = inImg.m_84982_();
                int height = inImg.m_85084_();
                NativeImage out = NativeImageHelper.of(NativeImage.Format.RGBA, width, height, false);
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < width; ++y) {
                        int source = inImg.m_84985_(x, y);
                        out.m_84988_(x, y, ~source);
                    }
                }
                NativeImage nativeImage = out;
                return nativeImage;
            }
        };
    }

    public TexSource getSource() {
        return this.source;
    }

    public static class Builder {
        private TexSource source;

        public Builder setSource(TexSource source) {
            this.source = source;
            return this;
        }

        public InvertMask build() {
            Objects.requireNonNull(this.source);
            return new InvertMask(this.source);
        }
    }
}

