/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources.mask;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.impl.client.NativeImageHelper;
import java.util.Objects;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.Nullable;

public final class GrowMask
implements TexSource {
    private static final float DEFAULT_GROWTH = 0.0625f;
    private static final int DEFAULT_CUTOFF = 128;
    public static final Codec<GrowMask> CODEC = RecordCodecBuilder.create(i -> i.group((App)TexSource.CODEC.fieldOf("source").forGetter(GrowMask::getSource), (App)Codec.FLOAT.optionalFieldOf("growth", (Object)Float.valueOf(0.0625f)).forGetter(GrowMask::getGrowth), (App)Codec.INT.optionalFieldOf("cutoff", (Object)128).forGetter(GrowMask::getCutoff)).apply((Applicative)i, GrowMask::new));
    private final TexSource source;
    private final float growth;
    private final int cutoff;

    private GrowMask(TexSource source, float growth, int cutoff) {
        this.source = source;
        this.growth = growth;
        this.cutoff = cutoff;
    }

    @Override
    public Codec<? extends TexSource> codec() {
        return CODEC;
    }

    @Override
    @Nullable
    public IoSupplier<NativeImage> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        IoSupplier<NativeImage> input = this.source.getSupplier(data, context);
        if (input == null) {
            data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.source.stringify());
            return null;
        }
        return () -> {
            try (NativeImage inImg = (NativeImage)input.m_247737_();){
                int width = inImg.m_84982_();
                int height = inImg.m_85084_();
                int toGrow = (int)Math.floor((float)width * this.growth);
                int filterSize = toGrow * toGrow * 2 + 1;
                int[] xs = new int[filterSize];
                int[] ys = new int[filterSize];
                int counter = 0;
                for (int x = -toGrow; x <= toGrow; ++x) {
                    int y = -toGrow;
                    while (y <= toGrow) {
                        xs[counter] = x;
                        ys[counter] = y++;
                        ++counter;
                    }
                }
                NativeImage out = NativeImageHelper.of(NativeImage.Format.RGBA, width, height, false);
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < width; ++y) {
                        boolean shouldGrow = false;
                        for (int i : xs) {
                            for (int j : ys) {
                                int x1 = x + i;
                                int y1 = y + j;
                                if (x1 < toGrow || y1 < toGrow || x1 >= width - toGrow || y1 >= width - toGrow || FastColor.ABGR32.m_266503_((int)inImg.m_84985_(x1, y1)) < this.cutoff) continue;
                                shouldGrow = true;
                            }
                        }
                        if (shouldGrow) {
                            out.m_84988_(x, y, -1);
                            continue;
                        }
                        out.m_84988_(x, y, 0);
                    }
                }
                NativeImage nativeImage = out;
                return nativeImage;
            }
        };
    }

    public TexSource getSource() {
        return this.source;
    }

    public float getGrowth() {
        return this.growth;
    }

    public int getCutoff() {
        return this.cutoff;
    }

    public static class Builder {
        private TexSource source;
        private float growth = 0.0625f;
        private int cutoff = 128;

        public Builder setSource(TexSource source) {
            this.source = source;
            return this;
        }

        public Builder setGrowth(float growth) {
            this.growth = growth;
            return this;
        }

        public Builder setCutoff(int cutoff) {
            this.cutoff = cutoff;
            return this;
        }

        public GrowMask build() {
            Objects.requireNonNull(this.source);
            return new GrowMask(this.source, this.growth, this.cutoff);
        }
    }
}

