/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources.mask;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.api.client.image.ImageUtils;
import dev.lukebemish.dynamicassetgenerator.api.colors.Channel;
import dev.lukebemish.dynamicassetgenerator.api.colors.operations.PointwiseOperation;
import java.util.List;
import java.util.Objects;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;

public final class CutoffMask
implements TexSource {
    private static final int DEFAULT_CUTOFF = 128;
    private static final Channel DEFAULT_CHANNEL = Channel.ALPHA;
    public static final Codec<CutoffMask> CODEC = RecordCodecBuilder.create(i -> i.group((App)Channel.CODEC.optionalFieldOf("channel", (Object)DEFAULT_CHANNEL).forGetter(CutoffMask::getChannel), (App)TexSource.CODEC.fieldOf("source").forGetter(CutoffMask::getSource), (App)Codec.INT.optionalFieldOf("cutoff", (Object)128).forGetter(CutoffMask::getCutoff)).apply((Applicative)i, CutoffMask::new));
    private final Channel channel;
    private final TexSource source;
    private final int cutoff;

    private CutoffMask(Channel channel, TexSource source, int cutoff) {
        this.channel = channel;
        this.source = source;
        this.cutoff = cutoff;
    }

    @Override
    public Codec<? extends TexSource> codec() {
        return CODEC;
    }

    @Override
    @Nullable
    public IoSupplier<NativeImage> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        IoSupplier<NativeImage> input = this.source.getSupplier(data, context);
        if (input == null) {
            data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.source.stringify());
            return null;
        }
        return () -> {
            PointwiseOperation.Unary<Integer> operation = PointwiseOperation.Unary.chain(this.channel.makeOperation(), (c, i) -> i ? (c >= this.cutoff ? -1 : 0) : 0);
            try (NativeImage inImg = (NativeImage)input.m_247737_();){
                NativeImage nativeImage = ImageUtils.generateScaledImage(operation, List.of(inImg));
                return nativeImage;
            }
        };
    }

    public Channel getChannel() {
        return this.channel;
    }

    public TexSource getSource() {
        return this.source;
    }

    public int getCutoff() {
        return this.cutoff;
    }

    public static class Builder {
        private Channel channel = DEFAULT_CHANNEL;
        private TexSource source;
        private int cutoff = 128;

        public Builder setChannel(Channel channel) {
            this.channel = channel;
            return this;
        }

        public Builder setSource(TexSource source) {
            this.source = source;
            return this;
        }

        public Builder setCutoff(int cutoff) {
            this.cutoff = cutoff;
            return this;
        }

        public CutoffMask build() {
            Objects.requireNonNull(this.source);
            return new CutoffMask(this.channel, this.source, this.cutoff);
        }
    }
}

