/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.api.client.image.ImageUtils;
import dev.lukebemish.dynamicassetgenerator.impl.client.NativeImageHelper;
import java.util.Objects;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;

public final class TransformSource
implements TexSource {
    private static final int DEFAULT_ROTATE = 0;
    private static final boolean DEFAULT_FLIP = false;
    public static final Codec<TransformSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TexSource.CODEC.fieldOf("input").forGetter(TransformSource::getInput), (App)Codec.INT.optionalFieldOf("rotate", (Object)0).forGetter(TransformSource::getRotate), (App)Codec.BOOL.optionalFieldOf("flip", (Object)false).forGetter(TransformSource::isFlip)).apply((Applicative)instance, TransformSource::new));
    private final TexSource input;
    private final int rotate;
    private final boolean flip;

    private TransformSource(TexSource input, int rotate, boolean flip) {
        this.input = input;
        this.rotate = rotate;
        this.flip = flip;
    }

    @Override
    public Codec<? extends TexSource> codec() {
        return CODEC;
    }

    @Override
    @Nullable
    public IoSupplier<NativeImage> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        IoSupplier<NativeImage> input = this.getInput().getSupplier(data, context);
        if (input == null) {
            data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.getInput());
            return null;
        }
        return () -> {
            NativeImage output = (NativeImage)input.m_247737_();
            for (int i = 0; i < this.getRotate(); ++i) {
                output = TransformSource.clockwiseRotate(output);
            }
            if (this.isFlip()) {
                NativeImage output2 = NativeImageHelper.of(output.m_85102_(), output.m_84982_(), output.m_85084_(), false);
                for (int x = 0; x < output.m_84982_(); ++x) {
                    for (int y = 0; y < output.m_85084_(); ++y) {
                        output2.m_84988_(output.m_84982_() - 1 - x, y, ImageUtils.safeGetPixelABGR(output, x, y));
                    }
                }
                output.close();
                output = output2;
            }
            return output;
        };
    }

    private static NativeImage clockwiseRotate(NativeImage input) {
        int w = input.m_84982_();
        int h = input.m_85084_();
        NativeImage output = NativeImageHelper.of(input.m_85102_(), h, w, false);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                output.m_84988_(y, w - x - 1, ImageUtils.safeGetPixelABGR(input, x, y));
            }
        }
        input.close();
        return output;
    }

    public TexSource getInput() {
        return this.input;
    }

    public int getRotate() {
        return this.rotate;
    }

    public boolean isFlip() {
        return this.flip;
    }

    public static class Builder {
        private TexSource input;
        private int rotate = 0;
        private boolean flip = false;

        public Builder setInput(TexSource input) {
            this.input = input;
            return this;
        }

        public Builder setRotate(int rotate) {
            this.rotate = rotate;
            return this;
        }

        public Builder setFlip(boolean flip) {
            this.flip = flip;
            return this;
        }

        public TransformSource build() {
            Objects.requireNonNull(this.input);
            return new TransformSource(this.input, this.rotate, this.flip);
        }
    }
}

