/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TouchedTextureTracker;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.IoSupplier;

public final class TextureReaderSource
implements TexSource {
    public static final Codec<TextureReaderSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("path").forGetter(TextureReaderSource::getPath)).apply((Applicative)instance, TextureReaderSource::new));
    private final ResourceLocation path;

    private TextureReaderSource(ResourceLocation path) {
        this.path = path;
    }

    @Override
    public Codec<? extends TexSource> codec() {
        return CODEC;
    }

    @Override
    public IoSupplier<NativeImage> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        TouchedTextureTracker tracker = data.get(TouchedTextureTracker.class);
        if (tracker != null) {
            tracker.addTouchedTexture(this.getPath());
        }
        ResourceLocation outRl = new ResourceLocation(this.getPath().m_135827_(), "textures/" + this.getPath().m_135815_() + ".png");
        return () -> {
            try {
                IoSupplier<InputStream> in = context.getResource(outRl);
                if (in != null) {
                    return NativeImage.m_85058_((InputStream)((InputStream)in.m_247737_()));
                }
                data.getLogger().error("Texture not available in context: {}", (Object)this.getPath());
            }
            catch (IOException e) {
                data.getLogger().error("Issue loading texture: {}", (Object)this.getPath());
            }
            throw new IOException("Issue loading texture: " + this.getPath());
        };
    }

    public ResourceLocation getPath() {
        return this.path;
    }

    public static class Builder {
        private ResourceLocation path;

        public Builder setPath(ResourceLocation path) {
            this.path = path;
            return this;
        }

        public TextureReaderSource build() {
            Objects.requireNonNull(this.path);
            return new TextureReaderSource(this.path);
        }
    }
}

