/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.api.client.image.ImageUtils;
import dev.lukebemish.dynamicassetgenerator.api.colors.ColorTools;
import dev.lukebemish.dynamicassetgenerator.api.colors.Palette;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.Nullable;

public class ShadowedSource
implements TexSource {
    private static final int DEFAULT_EXTEND_PALETTE_SIZE = 6;
    private static final int DEFAULT_HIGHLIGHT_STRENGTH = 72;
    private static final int DEFAULT_SHADOW_STRENGTH = 72;
    private static final float DEFAULT_UNIFORMITY = 1.0f;
    private static final int[] LOW_X = new int[]{1, 0};
    private static final int[] LOW_Y = new int[]{0, 1};
    private static final int[] HIGH_X = new int[]{-1, 0};
    private static final int[] HIGH_Y = new int[]{0, -1};
    public static final Codec<ShadowedSource> CODEC = RecordCodecBuilder.create(i -> i.group((App)TexSource.CODEC.fieldOf("background").forGetter(ShadowedSource::getBackground), (App)TexSource.CODEC.fieldOf("foreground").forGetter(ShadowedSource::getForeground), (App)Codec.INT.optionalFieldOf("extend_palette_size", (Object)6).forGetter(ShadowedSource::getExtendPaletteSize), (App)Codec.INT.optionalFieldOf("highlight_strength", (Object)72).forGetter(ShadowedSource::getHighlightStrength), (App)Codec.INT.optionalFieldOf("shadow_strength", (Object)72).forGetter(ShadowedSource::getShadowStrength), (App)Codec.FLOAT.optionalFieldOf("uniformity", (Object)Float.valueOf(1.0f)).forGetter(ShadowedSource::getUniformity)).apply((Applicative)i, ShadowedSource::new));
    private final TexSource background;
    private final TexSource foreground;
    private final int extendPaletteSize;
    private final int highlightStrength;
    private final int shadowStrength;
    private final float uniformity;

    private ShadowedSource(TexSource background, TexSource foreground, int extendPaletteSize, int highlightStrength, int shadowStrength, float uniformity) {
        this.background = background;
        this.foreground = foreground;
        this.extendPaletteSize = extendPaletteSize;
        this.highlightStrength = highlightStrength;
        this.shadowStrength = shadowStrength;
        this.uniformity = uniformity;
    }

    @Override
    public Codec<? extends TexSource> codec() {
        return CODEC;
    }

    @Override
    @Nullable
    public IoSupplier<NativeImage> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        IoSupplier<NativeImage> background = this.getBackground().getSupplier(data, context);
        IoSupplier<NativeImage> foreground = this.getForeground().getSupplier(data, context);
        if (background == null) {
            data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.getBackground().stringify());
            return null;
        }
        if (foreground == null) {
            data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.getForeground().stringify());
            return null;
        }
        return () -> {
            try (NativeImage backgroundImage = (NativeImage)background.m_247737_();){
                NativeImage nativeImage;
                block12: {
                    NativeImage foregroundImage = (NativeImage)foreground.m_247737_();
                    try {
                        Pair<Integer, Integer> size = ImageUtils.calculateScaledSize(List.of(backgroundImage, foregroundImage));
                        int bScale = (Integer)size.getFirst() / backgroundImage.m_84982_();
                        int fScale = (Integer)size.getFirst() / foregroundImage.m_84982_();
                        NativeImage image = new NativeImage(((Integer)size.getFirst()).intValue(), ((Integer)size.getSecond()).intValue(), false);
                        Palette palette = ImageUtils.getPalette(backgroundImage);
                        palette.extendToSize(this.getExtendPaletteSize());
                        IntStream.range(0, (Integer)size.getFirst()).parallel().forEach(x -> {
                            for (int y = 0; y < (Integer)size.getSecond(); ++y) {
                                int i;
                                ImageUtils.safeSetPixelABGR(image, x, y, 0);
                                boolean high = false;
                                boolean low = false;
                                for (i = 0; i < LOW_X.length; ++i) {
                                    if (FastColor.ABGR32.m_266503_((int)ImageUtils.safeGetPixelABGR(foregroundImage, (x + LOW_X[i]) / fScale, (y + LOW_Y[i]) / fScale)) < 128) continue;
                                    low = true;
                                    break;
                                }
                                for (i = 0; i < HIGH_X.length; ++i) {
                                    if (FastColor.ABGR32.m_266503_((int)ImageUtils.safeGetPixelABGR(foregroundImage, (x + HIGH_X[i]) / fScale, (y + HIGH_Y[i]) / fScale)) < 128) continue;
                                    high = true;
                                    break;
                                }
                                if (high && low) {
                                    high = false;
                                    low = false;
                                }
                                int oldBackground = ImageUtils.safeGetPixelARGB(backgroundImage, x / bScale, y / bScale);
                                int oldForeground = ImageUtils.safeGetPixelARGB(foregroundImage, x / fScale, y / fScale);
                                if (high || low) {
                                    int sample = palette.getSample(oldBackground);
                                    sample = (int)(((float)sample + (float)palette.originalCenterSample() * this.getUniformity()) / (1.0f + this.getUniformity()));
                                    sample = high ? (sample += this.getHighlightStrength()) : (sample -= this.getShadowStrength());
                                    sample = ColorTools.clamp8(sample);
                                    int newColor = palette.getColor(sample) | oldBackground & 0xFF000000;
                                    ImageUtils.safeSetPixelARGB(image, x, y, ColorTools.ARGB32.alphaBlend(oldForeground, newColor));
                                    continue;
                                }
                                ImageUtils.safeSetPixelARGB(image, x, y, ColorTools.ARGB32.alphaBlend(oldForeground, oldBackground));
                            }
                        });
                        nativeImage = image;
                        if (foregroundImage == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (foregroundImage != null) {
                            try {
                                foregroundImage.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    foregroundImage.close();
                }
                return nativeImage;
            }
        };
    }

    public float getUniformity() {
        return this.uniformity;
    }

    public int getShadowStrength() {
        return this.shadowStrength;
    }

    public int getHighlightStrength() {
        return this.highlightStrength;
    }

    public int getExtendPaletteSize() {
        return this.extendPaletteSize;
    }

    public TexSource getForeground() {
        return this.foreground;
    }

    public TexSource getBackground() {
        return this.background;
    }

    public static class Builder {
        private TexSource background;
        private TexSource foreground;
        private int extendPaletteSize = 6;
        private int highlightStrength = 72;
        private int shadowStrength = 72;
        private float uniformity = 1.0f;

        public Builder setBackground(TexSource background) {
            this.background = background;
            return this;
        }

        public Builder setForeground(TexSource foreground) {
            this.foreground = foreground;
            return this;
        }

        public Builder setExtendPaletteSize(int extendPaletteSize) {
            this.extendPaletteSize = extendPaletteSize;
            return this;
        }

        public Builder setHighlightStrength(int highlightStrength) {
            this.highlightStrength = highlightStrength;
            return this;
        }

        public Builder setShadowStrength(int shadowStrength) {
            this.shadowStrength = shadowStrength;
            return this;
        }

        public Builder setUniformity(float uniformity) {
            this.uniformity = uniformity;
            return this;
        }

        public ShadowedSource build() {
            Objects.requireNonNull(this.background);
            Objects.requireNonNull(this.foreground);
            return new ShadowedSource(this.background, this.foreground, this.extendPaletteSize, this.highlightStrength, this.shadowStrength, this.uniformity);
        }
    }
}

