/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.api.client.image.ImageUtils;
import dev.lukebemish.dynamicassetgenerator.api.colors.ColorTools;
import dev.lukebemish.dynamicassetgenerator.api.colors.operations.PointwiseOperation;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class PaletteSpreadSource
implements TexSource {
    private static final List<Range> DEFAULT_RANGE = List.of(new Range(0, 255));
    public static final Codec<PaletteSpreadSource> CODEC = RecordCodecBuilder.create(i -> i.group((App)TexSource.CODEC.fieldOf("source").forGetter(PaletteSpreadSource::getSource), (App)Codec.DOUBLE.optionalFieldOf("palette_cutoff", (Object)3.5).forGetter(PaletteSpreadSource::getPaletteCutoff), (App)Codec.either(Range.CODEC, (Codec)Range.CODEC.listOf()).xmap(either -> (List)either.map(List::of, Function.identity()), list -> list.size() == 1 ? Either.left((Object)((Range)list.get(0))) : Either.right((Object)list)).flatXmap(list -> {
        if (!PaletteSpreadSource.verifyDisjoint(list)) {
            return DataResult.error(() -> "Ranges must be disjoint");
        }
        return DataResult.success((Object)list);
    }, DataResult::success).optionalFieldOf("range", DEFAULT_RANGE).forGetter(PaletteSpreadSource::getRange)).apply((Applicative)i, PaletteSpreadSource::new));
    private final TexSource source;
    private final double paletteCutoff;
    private final List<Range> range;

    private PaletteSpreadSource(TexSource source, double paletteCutoff, List<Range> range) {
        this.source = source;
        this.paletteCutoff = paletteCutoff;
        this.range = range;
    }

    private static boolean verifyDisjoint(List<Range> ranges) {
        if (ranges.size() == 0) {
            return false;
        }
        for (int i = 0; i < ranges.size(); ++i) {
            if (ranges.get(i).lowerBound() > ranges.get(i).upperBound()) {
                return false;
            }
            for (int j = i + 1; j < ranges.size() && j < i + 2; ++j) {
                if (ranges.get(i).upperBound() <= ranges.get(j).lowerBound()) continue;
                return false;
            }
        }
        return true;
    }

    private static int mapToRange(float value, List<Range> ranges) {
        int sum = 0;
        for (Range range : ranges) {
            sum += range.upperBound() - range.lowerBound();
        }
        int current = 0;
        for (Range range : ranges) {
            int rangeSize = range.upperBound() - range.lowerBound();
            if (value < (float)(current + rangeSize)) {
                float out = (float)range.lowerBound() + (value - (float)current) * (float)rangeSize / (float)sum;
                return ColorTools.clamp8((int)((double)out + 0.5));
            }
            current += rangeSize;
        }
        return ranges.get(ranges.size() - 1).upperBound();
    }

    @Override
    public Codec<? extends TexSource> codec() {
        return CODEC;
    }

    @Override
    @Nullable
    public IoSupplier<NativeImage> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        IoSupplier<NativeImage> source = this.getSource().getSupplier(data, context);
        if (source == null) {
            data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.getSource().stringify());
            return null;
        }
        return () -> {
            try (NativeImage paletteImage = (NativeImage)source.m_247737_();){
                int min = 255;
                int max = 0;
                for (int i = 0; i < paletteImage.m_84982_(); ++i) {
                    for (int j = 0; j < paletteImage.m_85084_(); ++j) {
                        int color2 = paletteImage.m_84985_(i, j);
                        int value = (FastColor.ABGR32.m_266313_((int)color2) + FastColor.ABGR32.m_266446_((int)color2) + FastColor.ABGR32.m_266247_((int)color2)) / 3;
                        if (value < min) {
                            min = value;
                        }
                        if (value <= max) continue;
                        max = value;
                    }
                }
                int finalMax = max;
                int finalMin = min;
                PointwiseOperation.Unary<Integer> operation = (color, isInBounds) -> {
                    int value = (FastColor.ARGB32.m_13665_((int)color) + FastColor.ARGB32.m_13667_((int)color) + FastColor.ARGB32.m_13669_((int)color)) / 3;
                    float stretched = (float)(value - finalMin) * 255.0f / (float)(finalMax - finalMin);
                    int out = PaletteSpreadSource.mapToRange(stretched, this.getRange());
                    return FastColor.ARGB32.m_13660_((int)FastColor.ARGB32.m_13655_((int)color), (int)out, (int)out, (int)out);
                };
                NativeImage nativeImage = ImageUtils.generateScaledImage(operation, List.of(paletteImage));
                return nativeImage;
            }
        };
    }

    public TexSource getSource() {
        return this.source;
    }

    public double getPaletteCutoff() {
        return this.paletteCutoff;
    }

    public List<Range> getRange() {
        return this.range;
    }

    public record Range(int lowerBound, int upperBound) {
        public static final Codec<Range> CODEC = Codec.intRange((int)0, (int)255).listOf().flatXmap(list -> {
            if (list.size() != 2) {
                return DataResult.error(() -> "Range must have exactly 2 elements");
            }
            if ((Integer)list.get(1) <= (Integer)list.get(0)) {
                return DataResult.error(() -> "Second element of range must be larger than the first");
            }
            return DataResult.success((Object)new Range((Integer)list.get(0), (Integer)list.get(1)));
        }, range -> DataResult.success(List.of(Integer.valueOf(range.lowerBound()), Integer.valueOf(range.upperBound()))));
    }

    public static class Builder {
        private TexSource source;
        private double paletteCutoff = 3.5;
        private List<Range> range = DEFAULT_RANGE;

        public Builder setSource(TexSource source) {
            this.source = source;
            return this;
        }

        public Builder setPaletteCutoff(double paletteCutoff) {
            this.paletteCutoff = paletteCutoff;
            return this;
        }

        public Builder setRange(List<Range> range) {
            this.range = range;
            return this;
        }

        public PaletteSpreadSource build() {
            Objects.requireNonNull(this.source);
            return new PaletteSpreadSource(this.source, this.paletteCutoff, this.range);
        }
    }
}

