/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.api.client.image.ImageUtils;
import dev.lukebemish.dynamicassetgenerator.api.colors.Palette;
import dev.lukebemish.dynamicassetgenerator.api.colors.operations.ColorOperations;
import dev.lukebemish.dynamicassetgenerator.api.colors.operations.PaletteToColorOperation;
import dev.lukebemish.dynamicassetgenerator.api.colors.operations.PointwiseOperation;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PaletteCombinedSource
implements TexSource {
    private static final boolean DEFAULT_INCLUDE_BACKGROUND = true;
    private static final boolean DEFAULT_STRETCH_PALETTED = false;
    private static final int DEFAULT_EXTEND_PALETTE_SIZE = 6;
    public static final Codec<PaletteCombinedSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TexSource.CODEC.fieldOf("overlay").forGetter(PaletteCombinedSource::getOverlay), (App)TexSource.CODEC.fieldOf("background").forGetter(PaletteCombinedSource::getBackground), (App)TexSource.CODEC.fieldOf("paletted").forGetter(PaletteCombinedSource::getPaletted), (App)Codec.BOOL.optionalFieldOf("include_background", (Object)true).forGetter(PaletteCombinedSource::isIncludeBackground), (App)Codec.BOOL.optionalFieldOf("stretch_paletted", (Object)false).forGetter(PaletteCombinedSource::isStretchPaletted), (App)Codec.INT.optionalFieldOf("extend_palette_size", (Object)6).forGetter(PaletteCombinedSource::getExtendPaletteSize)).apply((Applicative)instance, PaletteCombinedSource::new));
    private final TexSource overlay;
    private final TexSource background;
    private final TexSource paletted;
    private final boolean includeBackground;
    private final boolean stretchPaletted;
    private final int extendPaletteSize;

    private PaletteCombinedSource(TexSource overlay, TexSource background, TexSource paletted, boolean includeBackground, boolean stretchPaletted, int extendPaletteSize) {
        this.overlay = overlay;
        this.background = background;
        this.paletted = paletted;
        this.includeBackground = includeBackground;
        this.stretchPaletted = stretchPaletted;
        this.extendPaletteSize = extendPaletteSize;
    }

    public Codec<PaletteCombinedSource> codec() {
        return CODEC;
    }

    @Override
    @Nullable
    public IoSupplier<NativeImage> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        IoSupplier<NativeImage> backgroundSupplier = this.background.getSupplier(data, context);
        IoSupplier<NativeImage> overlaySupplier = this.overlay.getSupplier(data, context);
        IoSupplier<NativeImage> palettedSupplier = this.paletted.getSupplier(data, context);
        if (backgroundSupplier == null) {
            data.getLogger().error("Background image was none... \n{}", (Object)this.background.stringify());
            return null;
        }
        if (overlaySupplier == null) {
            data.getLogger().error("Overlay image was none... \n{}", (Object)this.overlay.stringify());
            return null;
        }
        if (palettedSupplier == null) {
            data.getLogger().error("Paletted image was none... \n{}", (Object)this.paletted.stringify());
            return null;
        }
        return () -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        };
    }

    @NotNull
    public static NativeImage combineImages(NativeImage backgroundImage, NativeImage overlayImage, NativeImage paletteImage, PaletteCombiningOptions options) {
        PointwiseOperation.Unary<Integer> stretcher;
        Palette palette = ImageUtils.getPalette(backgroundImage);
        palette.extend(options.palettePredicate());
        if (options.stretchPaletted()) {
            int min = 255;
            int max = 0;
            for (int i = 0; i < paletteImage.m_84982_(); ++i) {
                for (int j = 0; j < paletteImage.m_85084_(); ++j) {
                    int color2 = paletteImage.m_84985_(i, j);
                    int value = (FastColor.ABGR32.m_266313_((int)color2) + FastColor.ABGR32.m_266446_((int)color2) + FastColor.ABGR32.m_266247_((int)color2)) / 3;
                    if (value < min) {
                        min = value;
                    }
                    if (value <= max) continue;
                    max = value;
                }
            }
            int finalMax = max;
            int finalMin = min;
            stretcher = (color, isInBounds) -> {
                int value = (FastColor.ARGB32.m_13665_((int)color) + FastColor.ARGB32.m_13667_((int)color) + FastColor.ARGB32.m_13669_((int)color)) / 3;
                int stretched = (value - finalMin) * 255 / (finalMax - finalMin);
                return FastColor.ARGB32.m_13660_((int)FastColor.ARGB32.m_13655_((int)color), (int)stretched, (int)stretched, (int)stretched);
            };
        } else {
            stretcher = (color, isInBounds) -> color;
        }
        PaletteToColorOperation paletteResolver = new PaletteToColorOperation(palette);
        PointwiseOperation.Ternary<Integer> operation = (background, overlay, paletted, backgroundInBounds, overlayInBounds, palettedInBounds) -> {
            boolean[] blArray;
            int[] nArray;
            paletted = (Integer)stretcher.apply(paletted, palettedInBounds);
            int resolvedPalette = (Integer)paletteResolver.apply(paletted, palettedInBounds);
            if (options.includeBackground()) {
                int[] nArray2 = new int[3];
                nArray2[0] = overlay;
                nArray2[1] = resolvedPalette;
                nArray = nArray2;
                nArray2[2] = background;
            } else {
                int[] nArray3 = new int[2];
                nArray3[0] = overlay;
                nArray = nArray3;
                nArray3[1] = resolvedPalette;
            }
            int[] toOverlay = nArray;
            if (options.includeBackground()) {
                boolean[] blArray2 = new boolean[3];
                blArray2[0] = overlayInBounds;
                blArray2[1] = palettedInBounds;
                blArray = blArray2;
                blArray2[2] = backgroundInBounds;
            } else {
                boolean[] blArray3 = new boolean[2];
                blArray3[0] = overlayInBounds;
                blArray = blArray3;
                blArray3[1] = palettedInBounds;
            }
            boolean[] toOverlayInBounds = blArray;
            return (Integer)ColorOperations.OVERLAY.apply(toOverlay, toOverlayInBounds);
        };
        return ImageUtils.generateScaledImage(operation, List.of(backgroundImage, overlayImage, paletteImage));
    }

    public TexSource getOverlay() {
        return this.overlay;
    }

    public TexSource getBackground() {
        return this.background;
    }

    public TexSource getPaletted() {
        return this.paletted;
    }

    public boolean isIncludeBackground() {
        return this.includeBackground;
    }

    public boolean isStretchPaletted() {
        return this.stretchPaletted;
    }

    public int getExtendPaletteSize() {
        return this.extendPaletteSize;
    }

    private /* synthetic */ boolean lambda$getSupplier$1(Palette palette) {
        return palette.size() >= this.extendPaletteSize;
    }

    public record PaletteCombiningOptions(Predicate<Palette> palettePredicate, boolean stretchPaletted, boolean includeBackground) {
    }

    public static class Builder {
        private TexSource overlay;
        private TexSource background;
        private TexSource paletted;
        private boolean includeBackground = true;
        private boolean stretchPaletted = false;
        private int extendPaletteSize = 6;

        public Builder setOverlay(TexSource overlay) {
            this.overlay = overlay;
            return this;
        }

        public Builder setBackground(TexSource background) {
            this.background = background;
            return this;
        }

        public Builder setPaletted(TexSource paletted) {
            this.paletted = paletted;
            return this;
        }

        public Builder setIncludeBackground(boolean includeBackground) {
            this.includeBackground = includeBackground;
            return this;
        }

        public Builder setStretchPaletted(boolean stretchPaletted) {
            this.stretchPaletted = stretchPaletted;
            return this;
        }

        public Builder setExtendPaletteSize(int extendPaletteSize) {
            this.extendPaletteSize = extendPaletteSize;
            return this;
        }

        public PaletteCombinedSource build() {
            Objects.requireNonNull(this.overlay);
            Objects.requireNonNull(this.background);
            Objects.requireNonNull(this.paletted);
            return new PaletteCombinedSource(this.overlay, this.background, this.paletted, this.includeBackground, this.stretchPaletted, this.extendPaletteSize);
        }
    }
}

