/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.api.client.image.ImageUtils;
import dev.lukebemish.dynamicassetgenerator.api.colors.operations.ColorOperations;
import java.util.List;
import java.util.Objects;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;

public final class MaskSource
implements TexSource {
    public static final Codec<MaskSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TexSource.CODEC.fieldOf("input").forGetter(MaskSource::getInput), (App)TexSource.CODEC.fieldOf("mask").forGetter(MaskSource::getMask)).apply((Applicative)instance, MaskSource::new));
    private final TexSource input;
    private final TexSource mask;

    private MaskSource(TexSource input, TexSource mask) {
        this.input = input;
        this.mask = mask;
    }

    @Override
    public Codec<? extends TexSource> codec() {
        return CODEC;
    }

    @Override
    @Nullable
    public IoSupplier<NativeImage> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        IoSupplier<NativeImage> input = this.getInput().getSupplier(data, context);
        IoSupplier<NativeImage> mask = this.getMask().getSupplier(data, context);
        if (input == null) {
            data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.getMask().stringify());
            return null;
        }
        if (mask == null) {
            data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.getInput().stringify());
            return null;
        }
        return () -> {
            try (NativeImage inImg = (NativeImage)input.m_247737_();){
                NativeImage nativeImage;
                block12: {
                    NativeImage maskImg = (NativeImage)mask.m_247737_();
                    try {
                        nativeImage = ImageUtils.generateScaledImage(ColorOperations.MASK, List.of(inImg, maskImg));
                        if (maskImg == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (maskImg != null) {
                            try {
                                maskImg.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    maskImg.close();
                }
                return nativeImage;
            }
        };
    }

    public TexSource getInput() {
        return this.input;
    }

    public TexSource getMask() {
        return this.mask;
    }

    public static class Builder {
        private TexSource input;
        private TexSource mask;

        public Builder setInput(TexSource input) {
            this.input = input;
            return this;
        }

        public Builder setMask(TexSource mask) {
            this.mask = mask;
            return this;
        }

        public MaskSource build() {
            Objects.requireNonNull(this.input);
            Objects.requireNonNull(this.mask);
            return new MaskSource(this.input, this.mask);
        }
    }
}

