/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources;

import com.google.gson.Gson;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.cache.CacheMetaJsonOps;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.api.colors.Palette;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import java.util.Objects;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;

public final class ForegroundTransferSource
implements TexSource {
    private static final int DEFAULT_EXTEND_PALETTE_SIZE = 6;
    private static final boolean DEFAULT_TRIM_TRAILING = true;
    private static final boolean DEFAULT_FORCE_NEIGHBORS = true;
    private static final boolean DEFAULT_FILL_HOLES = true;
    private static final double DEFAULT_CLOSE_CUTOFF = 2.0;
    public static final Codec<ForegroundTransferSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TexSource.CODEC.fieldOf("background").forGetter(ForegroundTransferSource::getBackground), (App)TexSource.CODEC.fieldOf("full").forGetter(ForegroundTransferSource::getFull), (App)TexSource.CODEC.fieldOf("new_background").forGetter(ForegroundTransferSource::getNewBackground), (App)Codec.INT.optionalFieldOf("extend_palette_size", (Object)6).forGetter(ForegroundTransferSource::getExtendPaletteSize), (App)Codec.BOOL.optionalFieldOf("trim_trailing", (Object)true).forGetter(ForegroundTransferSource::isTrimTrailing), (App)Codec.BOOL.optionalFieldOf("force_neighbors", (Object)true).forGetter(ForegroundTransferSource::isForceNeighbors), (App)Codec.BOOL.optionalFieldOf("fill_holes", (Object)true).forGetter(ForegroundTransferSource::isFillHoles), (App)Codec.DOUBLE.optionalFieldOf("close_cutoff", (Object)2.0).forGetter(ForegroundTransferSource::getCloseCutoff)).apply((Applicative)instance, ForegroundTransferSource::new));
    private final TexSource background;
    private final TexSource full;
    private final TexSource newBackground;
    private final int extendPaletteSize;
    private final boolean trimTrailing;
    private final boolean forceNeighbors;
    private final boolean fillHoles;
    private final double closeCutoff;

    private ForegroundTransferSource(TexSource background, TexSource full, TexSource newBackground, int extendPaletteSize, boolean trimTrailing, boolean forceNeighbors, boolean fillHoles, double closeCutoff) {
        this.background = background;
        this.full = full;
        this.newBackground = newBackground;
        this.extendPaletteSize = extendPaletteSize;
        this.trimTrailing = trimTrailing;
        this.forceNeighbors = forceNeighbors;
        this.fillHoles = fillHoles;
        this.closeCutoff = closeCutoff;
    }

    @Override
    public Codec<? extends TexSource> codec() {
        return CODEC;
    }

    @Override
    @Nullable
    public IoSupplier<NativeImage> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        IoSupplier<NativeImage> background = this.getBackground().getSupplier(data, context);
        IoSupplier<NativeImage> newBackground = this.getNewBackground().getSupplier(data, context);
        IoSupplier<NativeImage> full = this.getFull().getSupplier(data, context);
        if (background == null) {
            data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.getBackground().stringify());
            return null;
        }
        if (newBackground == null) {
            data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.getNewBackground().stringify());
            return null;
        }
        if (full == null) {
            data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.getFull().stringify());
            return null;
        }
        CacheMetaJsonOps dataOps = new CacheMetaJsonOps();
        dataOps.putData(TexSourceDataHolder.class, data);
        DataResult cacheKeyBackground = TexSource.CODEC.encodeStart((DynamicOps)dataOps, (Object)this.getBackground()).map(arg_0 -> ((Gson)DynamicAssetGenerator.GSON_FLAT).toJson(arg_0));
        DataResult cacheKeyFull = TexSource.CODEC.encodeStart((DynamicOps)dataOps, (Object)this.getFull()).map(arg_0 -> ((Gson)DynamicAssetGenerator.GSON_FLAT).toJson(arg_0));
        DataResult cacheKey1 = cacheKeyBackground.result().isPresent() && cacheKeyFull.result().isPresent() ? DataResult.success((Object)((String)cacheKeyBackground.result().get() + "," + (String)cacheKeyFull.result().get() + "," + this.extendPaletteSize + "," + this.trimTrailing + "," + this.forceNeighbors + "," + this.fillHoles + "," + this.closeCutoff)) : (cacheKeyBackground.error().isPresent() ? DataResult.error(() -> "Failed to encode cache key: " + ((DataResult.PartialResult)cacheKeyBackground.error().get()).message()) : DataResult.error(() -> "Failed to encode cache key: " + ((DataResult.PartialResult)cacheKeyFull.error().get()).message()));
        DataResult cacheKey = cacheKey1;
        return () -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        };
    }

    public TexSource getBackground() {
        return this.background;
    }

    public TexSource getFull() {
        return this.full;
    }

    public TexSource getNewBackground() {
        return this.newBackground;
    }

    public int getExtendPaletteSize() {
        return this.extendPaletteSize;
    }

    public boolean isTrimTrailing() {
        return this.trimTrailing;
    }

    public boolean isForceNeighbors() {
        return this.forceNeighbors;
    }

    public boolean isFillHoles() {
        return this.fillHoles;
    }

    public double getCloseCutoff() {
        return this.closeCutoff;
    }

    private /* synthetic */ boolean lambda$getSupplier$3(Palette p) {
        return p.size() >= this.extendPaletteSize;
    }

    public static class Builder {
        private TexSource background;
        private TexSource full;
        private TexSource newBackground;
        private int extendPaletteSize = 6;
        private boolean trimTrailing = true;
        private boolean forceNeighbors = true;
        private boolean fillHoles = true;
        private double closeCutoff = 2.0;

        public Builder setBackground(TexSource background) {
            this.background = background;
            return this;
        }

        public Builder setFull(TexSource full) {
            this.full = full;
            return this;
        }

        public Builder setNewBackground(TexSource newBackground) {
            this.newBackground = newBackground;
            return this;
        }

        public Builder setExtendPaletteSize(int extendPaletteSize) {
            this.extendPaletteSize = extendPaletteSize;
            return this;
        }

        public Builder setTrimTrailing(boolean trimTrailing) {
            this.trimTrailing = trimTrailing;
            return this;
        }

        public Builder setForceNeighbors(boolean forceNeighbors) {
            this.forceNeighbors = forceNeighbors;
            return this;
        }

        public Builder setFillHoles(boolean fillHoles) {
            this.fillHoles = fillHoles;
            return this;
        }

        public Builder setCloseCutoff(double closeCutoff) {
            this.closeCutoff = closeCutoff;
            return this;
        }

        public ForegroundTransferSource build() {
            Objects.requireNonNull(this.background);
            Objects.requireNonNull(this.full);
            Objects.requireNonNull(this.newBackground);
            return new ForegroundTransferSource(this.background, this.full, this.newBackground, this.extendPaletteSize, this.trimTrailing, this.forceNeighbors, this.fillHoles, this.closeCutoff);
        }
    }
}

