/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public final class FallbackSource
implements TexSource {
    public static final Codec<FallbackSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TexSource.CODEC.fieldOf("original").forGetter(FallbackSource::getOriginal), (App)TexSource.CODEC.fieldOf("fallback").forGetter(FallbackSource::getFallback)).apply((Applicative)instance, FallbackSource::new));
    private final TexSource original;
    private final TexSource fallback;

    private FallbackSource(TexSource original, TexSource fallback) {
        this.original = original;
        this.fallback = fallback;
    }

    public Codec<FallbackSource> codec() {
        return CODEC;
    }

    @Override
    @Nullable
    public IoSupplier<NativeImage> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        TexSourceDataHolder newData = new TexSourceDataHolder(data);
        newData.put(Logger.class, NOPLogger.NOP_LOGGER);
        IoSupplier<NativeImage> original = this.getOriginal().getSupplier(newData, context);
        IoSupplier<NativeImage> fallback = this.getFallback().getSupplier(data, context);
        if (original == null && fallback == null) {
            data.getLogger().error("Both textures given were nonexistent...");
            return null;
        }
        return () -> {
            if (original != null) {
                try {
                    return (NativeImage)original.m_247737_();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (fallback != null) {
                return (NativeImage)fallback.m_247737_();
            }
            data.getLogger().error("Both textures given were unloadable...");
            throw new IOException("Both textures given were unloadable...");
        };
    }

    public TexSource getOriginal() {
        return this.original;
    }

    public TexSource getFallback() {
        return this.fallback;
    }

    public static class Builder {
        private TexSource original;
        private TexSource fallback;

        public Builder setOriginal(TexSource original) {
            this.original = original;
            return this;
        }

        public Builder setFallback(TexSource fallback) {
            this.fallback = fallback;
            return this;
        }

        public FallbackSource build() {
            Objects.requireNonNull(this.original);
            Objects.requireNonNull(this.fallback);
            return new FallbackSource(this.original, this.fallback);
        }
    }
}

