/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.api.client.image.ImageUtils;
import dev.lukebemish.dynamicassetgenerator.impl.client.NativeImageHelper;
import dev.lukebemish.dynamicassetgenerator.impl.util.Maath;
import dev.lukebemish.dynamicassetgenerator.impl.util.MultiCloser;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class AnimationSplittingSource
implements TexSource {
    public static final Codec<AnimationSplittingSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, TimeAwareSource.CODEC).fieldOf("sources").forGetter(AnimationSplittingSource::getSources), (App)TexSource.CODEC.fieldOf("generator").forGetter(AnimationSplittingSource::getGenerator)).apply((Applicative)instance, AnimationSplittingSource::new));
    private final Map<String, TimeAwareSource> sources;
    private final TexSource generator;

    private AnimationSplittingSource(Map<String, TimeAwareSource> sources, TexSource generator) {
        this.sources = sources;
        this.generator = generator;
    }

    @Override
    public Codec<? extends TexSource> codec() {
        return CODEC;
    }

    @Override
    @Nullable
    public IoSupplier<NativeImage> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        HashMap sources = new HashMap();
        HashMap times = new HashMap();
        this.getSources().forEach((key, source) -> {
            sources.put(key, source.source().getSupplier(data, context));
            times.put(key, source.scale());
        });
        if (sources.isEmpty()) {
            data.getLogger().error("No sources given...");
            return null;
        }
        return () -> {
            HashMap<String, NativeImage> images = new HashMap<String, NativeImage>();
            for (Map.Entry e : sources.entrySet()) {
                String key = (String)e.getKey();
                images.put(key, (NativeImage)((IoSupplier)e.getValue()).m_247737_());
            }
            try (MultiCloser ignored = new MultiCloser(images.values());){
                List imageList = images.values().stream().toList();
                List<Integer> counts = images.entrySet().stream().map(entry -> (Integer)times.get(entry.getKey()) * AnimationSplittingSource.getFrameCount((NativeImage)entry.getValue())).toList();
                for (int i : counts) {
                    if (i != 0) continue;
                    data.getLogger().error("Source not shaped correctly for an animation...");
                    throw new IOException("Source not shaped correctly for an animation...");
                }
                int lcm = Maath.lcm(counts);
                int lcmWidth = Maath.lcm(imageList.stream().map(NativeImage::m_84982_).toList());
                NativeImage output = NativeImageHelper.of(NativeImage.Format.RGBA, lcmWidth, lcmWidth * lcm, false);
                for (int i = 0; i < lcm; ++i) {
                    HashMap<String, NativeImage> map = new HashMap<String, NativeImage>();
                    int finalI = i;
                    images.forEach((str, old) -> map.put((String)str, AnimationSplittingSource.getPartialImage(old, finalI, (Integer)times.get(str))));
                    try (ImageCollection collection = new ImageCollection(map, this.getSources(), i);){
                        TexSourceDataHolder newData = new TexSourceDataHolder(data);
                        newData.put(ImageCollection.class, collection);
                        IoSupplier<NativeImage> supplier = this.generator.getSupplier(newData, context);
                        if (supplier == null) {
                            data.getLogger().error("Generator created no image...");
                            throw new IOException("Generator created no image...");
                        }
                        NativeImage supplied = (NativeImage)supplier.m_247737_();
                        int sWidth = supplied.m_84982_();
                        if (sWidth != supplied.m_85084_()) {
                            data.getLogger().error("Generator created non-square image...\n{}", (Object)this.generator.stringify());
                            throw new IOException("Generator created non-square image...");
                        }
                        int scale = lcmWidth / sWidth;
                        for (int x = 0; x < lcmWidth; ++x) {
                            for (int y = 0; y < lcmWidth; ++y) {
                                int color = ImageUtils.safeGetPixelABGR(supplied, x / scale, y / scale);
                                output.m_84988_(x, y + i * lcmWidth, color);
                            }
                        }
                        continue;
                    }
                }
                NativeImage nativeImage = output;
                return nativeImage;
            }
        };
    }

    private static int getFrameCount(NativeImage image) {
        return image.m_85084_() / image.m_84982_();
    }

    private static NativeImage getPartialImage(NativeImage input, int part, int scale) {
        int numFull = input.m_85084_() / input.m_84982_();
        int size = input.m_84982_();
        NativeImage output = NativeImageHelper.of(input.m_85102_(), size, size, false);
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                output.m_84988_(x, y, ImageUtils.safeGetPixelABGR(input, x, part / scale % numFull * size + y));
            }
        }
        return output;
    }

    public Map<String, TimeAwareSource> getSources() {
        return this.sources;
    }

    public TexSource getGenerator() {
        return this.generator;
    }

    @ApiStatus.Internal
    public static class ImageCollection
    implements Closeable {
        private final Map<String, NativeImage> map;
        private final Map<String, TimeAwareSource> original;
        private final int frame;

        @ApiStatus.Internal
        public ImageCollection(Map<String, NativeImage> map, Map<String, TimeAwareSource> original, int frame) {
            this.map = new HashMap<String, NativeImage>(map);
            this.original = original;
            this.frame = frame;
        }

        @Override
        public void close() {
            this.map.values().forEach(NativeImage::close);
        }

        public NativeImage get(String key) throws IOException {
            NativeImage input = this.map.get(key);
            if (input == null) {
                throw new IOException("No image for key: " + key);
            }
            NativeImage newImage = new NativeImage(input.m_85102_(), input.m_84982_(), input.m_85084_(), false);
            newImage.m_85054_(input);
            return newImage;
        }

        public int getFrame() {
            return this.frame;
        }

        public TimeAwareSource getFull(String key) {
            return this.original.get(key);
        }
    }

    public record TimeAwareSource(TexSource source, int scale) {
        public static final Codec<TimeAwareSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TexSource.CODEC.fieldOf("source").forGetter(TimeAwareSource::source), (App)Codec.INT.optionalFieldOf("scale", (Object)1).forGetter(TimeAwareSource::scale)).apply((Applicative)instance, TimeAwareSource::new));
    }

    public static class Builder {
        private Map<String, TimeAwareSource> sources;
        private TexSource generator;

        public Builder setSources(Map<String, TimeAwareSource> sources) {
            this.sources = sources;
            return this;
        }

        public Builder setGenerator(TexSource generator) {
            this.generator = generator;
            return this;
        }

        public AnimationSplittingSource build() {
            Objects.requireNonNull(this.sources);
            Objects.requireNonNull(this.generator);
            return new AnimationSplittingSource(this.sources, this.generator);
        }
    }
}

