/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.api.client.image.ImageUtils;
import dev.lukebemish.dynamicassetgenerator.api.colors.operations.PointwiseOperation;
import dev.lukebemish.dynamicassetgenerator.impl.util.MultiCloser;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractManyOperationSource
implements TexSource {
    private final List<TexSource> sources;

    public AbstractManyOperationSource(List<TexSource> sources) {
        this.sources = sources;
    }

    public List<TexSource> getSources() {
        return this.sources;
    }

    public abstract PointwiseOperation.Any<Integer> getOperation();

    public static <T extends AbstractManyOperationSource> Codec<T> makeCodec(Function<List<TexSource>, T> ctor) {
        return RecordCodecBuilder.create(instance -> instance.group((App)TexSource.CODEC.listOf().fieldOf("sources").forGetter(AbstractManyOperationSource::getSources)).apply((Applicative)instance, ctor));
    }

    @Override
    @Nullable
    public IoSupplier<NativeImage> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        ArrayList<IoSupplier<NativeImage>> inputs = new ArrayList<IoSupplier<NativeImage>>();
        for (TexSource o : this.getSources()) {
            IoSupplier<NativeImage> source = o.getSupplier(data, context);
            if (source == null) {
                data.getLogger().error("Texture given was nonexistent...\n{}", (Object)o.stringify());
                return null;
            }
            inputs.add(source);
        }
        return () -> {
            ArrayList<NativeImage> images = new ArrayList<NativeImage>();
            for (IoSupplier input : inputs) {
                images.add((NativeImage)input.m_247737_());
            }
            try (MultiCloser ignored = new MultiCloser(images);){
                NativeImage nativeImage = ImageUtils.generateScaledImage(this.getOperation(), images);
                return nativeImage;
            }
        };
    }
}

