/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.util.Maath;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record TextureMetaGenerator(List<ResourceLocation> sources, Optional<AnimationData> animation, Optional<VillagerData> villager, Optional<TextureData> texture, ResourceLocation outputLocation) implements ResourceGenerator
{
    public static final Codec<TextureMetaGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.listOf().fieldOf("sources").forGetter(TextureMetaGenerator::sources), (App)AnimationData.CODEC.optionalFieldOf("animation").forGetter(TextureMetaGenerator::animation), (App)VillagerData.CODEC.optionalFieldOf("villager").forGetter(TextureMetaGenerator::villager), (App)TextureData.CODEC.optionalFieldOf("texture").forGetter(TextureMetaGenerator::texture), (App)ResourceLocation.f_135803_.fieldOf("output_location").forGetter(TextureMetaGenerator::outputLocation)).apply((Applicative)instance, TextureMetaGenerator::new));
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().create();

    @Override
    public IoSupplier<InputStream> get(ResourceLocation outRl, ResourceGenerationContext context) {
        HashMap<ResourceLocation, MetaStructure> sourceStructure = new HashMap<ResourceLocation, MetaStructure>();
        if (this.sources().isEmpty()) {
            DynamicAssetGenerator.LOGGER.error("No sources provided for texture metadata at {}:\n", (Object)this.outputLocation());
            return null;
        }
        for (ResourceLocation source : this.sources()) {
            IoSupplier<InputStream> streamSupplier = context.getResource(new ResourceLocation(source.m_135827_(), "textures/" + source.m_135815_() + ".png.mcmeta"));
            if (streamSupplier == null) {
                sourceStructure.put(source, new MetaStructure(Optional.empty(), Optional.empty(), Optional.empty()));
                continue;
            }
            try {
                InputStream stream = (InputStream)streamSupplier.m_247737_();
                try {
                    JsonObject json = (JsonObject)GSON.fromJson((Reader)new BufferedReader(new InputStreamReader(stream)), JsonObject.class);
                    MetaStructure structure = (MetaStructure)MetaStructure.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, e -> {});
                    sourceStructure.put(source, structure);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException | RuntimeException e2) {
                sourceStructure.put(source, new MetaStructure(Optional.empty(), Optional.empty(), Optional.empty()));
            }
        }
        Optional<MetaStructure.AnimationMeta> animationMeta = Optional.empty();
        Optional<MetaStructure.VillagerMeta> villagerMeta = Optional.empty();
        Optional<MetaStructure.TextureMeta> textureMeta = Optional.empty();
        List<MetaStructure.AnimationMeta> animationMetas = this.sources().stream().map(sourceStructure::get).map(MetaStructure::animation).filter(Optional::isPresent).map(Optional::get).toList();
        List<MetaStructure.TextureMeta> textureMetas = this.sources().stream().map(sourceStructure::get).map(MetaStructure::texture).filter(Optional::isPresent).map(Optional::get).toList();
        List<MetaStructure.VillagerMeta> villagerMetas = this.sources().stream().map(sourceStructure::get).map(MetaStructure::villager).filter(Optional::isPresent).map(Optional::get).toList();
        if (!villagerMetas.isEmpty() || this.villager().isPresent()) {
            VillagerData.Hat hat = (this.villager().isPresent() ? this.villager().get().hat() : Optional.empty()).orElseGet(() -> ((MetaStructure.VillagerMeta)villagerMetas.get(0)).hat());
            villagerMeta = Optional.of(new MetaStructure.VillagerMeta(hat));
        }
        if (!textureMetas.isEmpty() || this.texture().isPresent()) {
            boolean blur = (this.texture().isPresent() ? this.texture().get().blur() : Optional.empty()).orElseGet(() -> ((MetaStructure.TextureMeta)textureMetas.get(0)).blur());
            boolean clamp = (this.texture().isPresent() ? this.texture().get().clamp() : Optional.empty()).orElseGet(() -> ((MetaStructure.TextureMeta)textureMetas.get(0)).clamp());
            textureMeta = Optional.of(new MetaStructure.TextureMeta(blur, clamp));
        }
        if (!animationMetas.isEmpty()) {
            int frametime = (this.animation().isPresent() ? this.animation().get().frametime() : Optional.empty()).orElseGet(() -> ((MetaStructure.AnimationMeta)animationMetas.get(0)).frametime());
            boolean interpolate = (this.animation().isPresent() ? this.animation().get().interpolate() : Optional.empty()).orElseGet(() -> ((MetaStructure.AnimationMeta)animationMetas.get(0)).interpolate());
            List<Integer> frameCount = animationMetas.stream().map(m -> m.frames.stream().max(Integer::compareTo).orElse(0) + 1).toList();
            ArrayList<Integer> scale = new ArrayList<Integer>(this.animation().map(AnimationData::scales).map(l -> l.orElse(List.of())).orElse(List.of()));
            ArrayList<Integer> relFrameCount = new ArrayList<Integer>();
            Supplier<ResourceLocation> rlFinder = () -> this.sources().stream().filter(i -> ((MetaStructure)sourceStructure.get(i)).animation().map(m -> !m.frames.equals(List.of(Integer.valueOf(0)))).orElse(false)).findFirst().orElse(this.sources().get(0));
            ResourceLocation patternSourceRl = this.animation().map(AnimationData::patternSource).map(s -> (ResourceLocation)s.orElseGet(rlFinder)).orElseGet(rlFinder);
            while (scale.size() < this.sources().size()) {
                scale.add(1);
            }
            for (int i = 0; i < frameCount.size(); ++i) {
                relFrameCount.add(frameCount.get(i) * (Integer)scale.get(i));
            }
            int totalLength = Maath.lcm(relFrameCount);
            if (!this.sources.contains(patternSourceRl)) {
                DynamicAssetGenerator.LOGGER.error("Source specified was not the name of a texture source: {}", (Object)patternSourceRl);
                return null;
            }
            List<Integer> framesSource = ((MetaStructure)sourceStructure.get((Object)patternSourceRl)).animation.map(MetaStructure.AnimationMeta::frames).orElse(List.of(Integer.valueOf(0)));
            int patternSourceIdx = ((MetaStructure)sourceStructure.get((Object)patternSourceRl)).animation.map(animationMetas::indexOf).orElse(0);
            ArrayList<Integer> framesOut = new ArrayList<Integer>();
            int scalingFactor = totalLength / frameCount.get(patternSourceIdx);
            for (int f : framesSource) {
                for (int i = 0; i < scalingFactor; ++i) {
                    framesOut.add(f * scalingFactor + i);
                }
            }
            animationMeta = Optional.of(new MetaStructure.AnimationMeta(frametime, framesOut, interpolate));
        }
        MetaStructure out = new MetaStructure(animationMeta, textureMeta, villagerMeta);
        JsonElement jsonOut = (JsonElement)MetaStructure.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)out).getOrThrow(false, e -> {});
        return () -> new ByteArrayInputStream(GSON.toJson(jsonOut).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    @NotNull
    public Set<ResourceLocation> getLocations() {
        return Set.of(new ResourceLocation(this.outputLocation().m_135827_(), "textures/" + this.outputLocation().m_135815_() + ".png.mcmeta"));
    }

    @Override
    public Codec<? extends ResourceGenerator> codec() {
        return CODEC;
    }

    private record MetaStructure(Optional<AnimationMeta> animation, Optional<TextureMeta> texture, Optional<VillagerMeta> villager) {
        public static final Codec<MetaStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)AnimationMeta.CODEC.optionalFieldOf("animation").forGetter(MetaStructure::animation), (App)TextureMeta.CODEC.optionalFieldOf("texture").forGetter(MetaStructure::texture), (App)VillagerMeta.CODEC.optionalFieldOf("villager").forGetter(MetaStructure::villager)).apply((Applicative)instance, MetaStructure::new));

        record AnimationMeta(int frametime, List<Integer> frames, boolean interpolate) {
            public static final Codec<AnimationMeta> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("frametime", (Object)1).forGetter(AnimationMeta::frametime), (App)Codec.INT.listOf().optionalFieldOf("frames", List.of(Integer.valueOf(0))).forGetter(AnimationMeta::frames), (App)Codec.BOOL.optionalFieldOf("interpolate", (Object)false).forGetter(AnimationMeta::interpolate)).apply((Applicative)instance, AnimationMeta::new));
        }

        record TextureMeta(boolean blur, boolean clamp) {
            public static final Codec<TextureMeta> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("blur", (Object)false).forGetter(TextureMeta::blur), (App)Codec.BOOL.optionalFieldOf("clamp", (Object)false).forGetter(TextureMeta::clamp)).apply((Applicative)instance, TextureMeta::new));
        }

        record VillagerMeta(VillagerData.Hat hat) {
            public static final Codec<VillagerMeta> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VillagerData.Hat.CODEC.optionalFieldOf("hat", (Object)VillagerData.Hat.NONE).forGetter(VillagerMeta::hat)).apply((Applicative)instance, VillagerMeta::new));
        }
    }

    public record VillagerData(Optional<Hat> hat) {
        public static final Codec<VillagerData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Hat.CODEC.optionalFieldOf("frametime").forGetter(VillagerData::hat)).apply((Applicative)instance, VillagerData::new));

        public static enum Hat implements StringRepresentable
        {
            NONE("none"),
            PARTIAL("partial"),
            FULL("full");

            public static final Codec<Hat> CODEC;
            private final String string;

            private Hat(String string2) {
                this.string = string2;
            }

            @NotNull
            public String m_7912_() {
                return this.string;
            }

            static {
                CODEC = StringRepresentable.m_216439_(Hat::values);
            }
        }
    }

    public record TextureData(Optional<Boolean> blur, Optional<Boolean> clamp) {
        public static final Codec<TextureData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("blur").forGetter(TextureData::blur), (App)Codec.BOOL.optionalFieldOf("clamp").forGetter(TextureData::clamp)).apply((Applicative)instance, TextureData::new));
    }

    public record AnimationData(Optional<Integer> frametime, Optional<Boolean> interpolate, Optional<ResourceLocation> patternSource, Optional<List<Integer>> scales) {
        public static final Codec<AnimationData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("frametime").forGetter(AnimationData::frametime), (App)Codec.BOOL.optionalFieldOf("interpolate").forGetter(AnimationData::interpolate), (App)ResourceLocation.f_135803_.optionalFieldOf("pattern_source").forGetter(AnimationData::patternSource), (App)Codec.INT.listOf().optionalFieldOf("scales").forGetter(AnimationData::scales)).apply((Applicative)instance, AnimationData::new));
    }

    public static class Builder {
        private final List<ResourceLocation> sources = new ArrayList<ResourceLocation>();
        @Nullable
        private AnimationData animation;
        @Nullable
        private VillagerData villager;
        @Nullable
        private TextureData texture;
        private ResourceLocation outputLocation;

        public Builder withSource(ResourceLocation location) {
            this.sources.add(location);
            return this;
        }

        public Builder withSources(List<ResourceLocation> locations) {
            this.sources.addAll(locations);
            return this;
        }

        public Builder withAnimation(AnimationData animation) {
            this.animation = animation;
            return this;
        }

        public Builder withVillager(VillagerData villager) {
            this.villager = villager;
            return this;
        }

        public Builder withTexture(TextureData texture) {
            this.texture = texture;
            return this;
        }

        public TextureMetaGenerator build() {
            Objects.requireNonNull(this.outputLocation);
            if (this.sources.size() < 1) {
                throw new IllegalStateException("At least one source must be provided");
            }
            return new TextureMetaGenerator(this.sources, Optional.ofNullable(this.animation), Optional.ofNullable(this.villager), Optional.ofNullable(this.texture), this.outputLocation);
        }

        public Builder withOutputLocation(ResourceLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }
    }
}

