/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerator;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class TextureGenerator
implements ResourceGenerator {
    public static final Codec<TextureGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("output_location").forGetter(dyn -> dyn.outputLocation), (App)TexSource.CODEC.fieldOf("input").forGetter(dyn -> dyn.input)).apply((Applicative)instance, TextureGenerator::new));
    private final ResourceLocation outputLocation;
    private final TexSource input;

    public TextureGenerator(@NotNull ResourceLocation outputLocation, @NotNull TexSource source) {
        this.input = source;
        this.outputLocation = outputLocation;
    }

    @Override
    public IoSupplier<InputStream> get(ResourceLocation outRl, ResourceGenerationContext context) {
        IoSupplier<NativeImage> imageGetter = this.input.getSupplier(new TexSourceDataHolder(), context);
        if (imageGetter == null) {
            return null;
        }
        return () -> {
            ByteArrayInputStream byteArrayInputStream;
            block9: {
                NativeImage image = (NativeImage)imageGetter.m_247737_();
                try {
                    byteArrayInputStream = new ByteArrayInputStream(image.m_85121_());
                    if (image == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (image != null) {
                            try {
                                image.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        DynamicAssetGenerator.LOGGER.error("Could not write image to stream for source {}: {}", (Object)this.input.stringify(), (Object)outRl, (Object)e);
                        throw e;
                    }
                    catch (Exception remainder) {
                        DynamicAssetGenerator.LOGGER.error("Unknown issue creating texture for output {} with source {}", (Object)outRl, (Object)this.input.stringify(), (Object)remainder);
                        throw new IOException(remainder);
                    }
                }
                image.close();
            }
            return byteArrayInputStream;
        };
    }

    @Override
    @NotNull
    public Set<ResourceLocation> getLocations() {
        return Set.of(this.getOutputLocation());
    }

    @ApiStatus.Internal
    public ResourceLocation getOutputLocation() {
        return new ResourceLocation(this.outputLocation.m_135827_(), "textures/" + this.outputLocation.m_135815_() + ".png");
    }

    @Override
    public Codec<? extends ResourceGenerator> codec() {
        return CODEC;
    }
}

