/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators;

import com.google.gson.JsonElement;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.cache.CacheMetaCodec;
import dev.lukebemish.dynamicassetgenerator.api.cache.DataConsumer;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.client.ClientRegisters;
import dev.lukebemish.dynamicassetgenerator.impl.client.TexSourceCachingWrapper;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TexSource {
    public static final String METADATA_CACHE_KEY = "__dynamic_asset_generator_metadata";
    public static final Codec<TexSource> CODEC = CacheMetaCodec.of(ExtraCodecs.m_184415_(() -> new Codec<Codec<? extends TexSource>>(){

        public <T> DataResult<Pair<Codec<? extends TexSource>, T>> decode(DynamicOps<T> ops, T input) {
            return ResourceLocation.f_135803_.decode(ops, input).flatMap(keyValuePair -> !ClientRegisters.TEXSOURCES.containsKey(keyValuePair.getFirst()) ? DataResult.error(() -> "Unknown dynamic texture source type: " + keyValuePair.getFirst()) : DataResult.success((Object)keyValuePair.mapFirst(arg_0 -> ClientRegisters.TEXSOURCES.get(arg_0))));
        }

        public <T> DataResult<T> encode(Codec<? extends TexSource> input, DynamicOps<T> ops, T prefix) {
            ResourceLocation key = (ResourceLocation)ClientRegisters.TEXSOURCES.inverse().get(input);
            if (key == null) {
                return DataResult.error(() -> "Unregistered dynamic texture source type: " + input);
            }
            Object toMerge = ops.createString(key.toString());
            return ops.mergeToPrimitive(prefix, toMerge);
        }
    }).dispatch(TexSource::codec, Function.identity()).xmap(TexSource::cached, wrapped -> {
        while (wrapped instanceof TexSourceCachingWrapper) {
            TexSourceCachingWrapper cachingWrapper = (TexSourceCachingWrapper)wrapped;
            wrapped = cachingWrapper.wrapped();
        }
        return wrapped;
    }), new DataConsumer<TexSourceDataHolder, TexSource>(){

        @Override
        @NotNull
        public <T1> DataResult<T1> encode(DynamicOps<T1> ops, TexSourceDataHolder data, TexSource object) {
            return object.cacheMetadata(ops, data);
        }
    }, "__dynamic_asset_generator_metadata", TexSourceDataHolder.class);

    public static <T extends TexSource> void register(ResourceLocation rl, Codec<T> codec) {
        ClientRegisters.TEXSOURCES.put((Object)rl, codec);
    }

    @NotNull
    @ApiStatus.Experimental
    default public <T> DataResult<T> cacheMetadata(DynamicOps<T> ops, TexSourceDataHolder data) {
        return DataResult.success((Object)ops.empty());
    }

    public Codec<? extends TexSource> codec();

    @Nullable
    public IoSupplier<NativeImage> getSupplier(TexSourceDataHolder var1, ResourceGenerationContext var2);

    @ApiStatus.Experimental
    default public TexSource cached() {
        if (this instanceof TexSourceCachingWrapper) {
            return this;
        }
        return new TexSourceCachingWrapper(this);
    }

    default public String stringify() {
        JsonElement element = CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().orElse(null);
        if (element == null) {
            return this.toString();
        }
        return DynamicAssetGenerator.GSON_FLAT.toJson(element);
    }
}

