/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.serialization.Codec;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TextureMetaGenerator;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TouchedTextureTracker;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.client.ExposesName;
import dev.lukebemish.dynamicassetgenerator.impl.client.ForegroundExtractor;
import dev.lukebemish.dynamicassetgenerator.impl.client.TexSourceCache;
import dev.lukebemish.dynamicassetgenerator.impl.client.platform.ClientServices;
import dev.lukebemish.dynamicassetgenerator.mixin.SpriteSourcesAccessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DynamicSpriteSource
extends SpriteSource {
    public Map<ResourceLocation, TexSource> getSources(ResourceGenerationContext var1, ResourceManager var2);

    public ResourceLocation getLocation();

    public static void register(ResourceLocation location, Codec<? extends DynamicSpriteSource> codec) {
        ClientServices.PLATFORM_CLIENT.addSpriteSource(location, codec);
    }

    public static void register(ResourceLocation location, Supplier<? extends DynamicSpriteSource> constructor) {
        ClientServices.PLATFORM_CLIENT.addSpriteSource(location, (Codec<? extends SpriteSource>)Codec.unit(constructor));
    }

    default public void reset(ResourceGenerationContext context) {
        TexSourceCache.reset(context);
        ForegroundExtractor.reset(context);
    }

    default public void m_260891_(final ResourceManager resourceManager, final SpriteSource.Output output) {
        ResourceGenerationContext context = new ResourceGenerationContext(){

            @Override
            @NotNull
            public ResourceLocation getCacheName() {
                if (output instanceof ExposesName) {
                    ExposesName exposesName = (ExposesName)output;
                    ResourceLocation atlasName = exposesName.dynamicassetgenerator$getName();
                    return DynamicSpriteSource.this.getLocation().m_247449_(DynamicSpriteSource.this.getLocation().m_135815_() + "__" + atlasName.m_135827_() + "__" + atlasName.m_135815_());
                }
                return DynamicSpriteSource.this.getLocation();
            }

            @Override
            @Nullable
            public IoSupplier<InputStream> getResource(@NotNull ResourceLocation location) {
                return resourceManager.m_213713_(location).map(resource -> () -> ((Resource)resource).m_215507_()).orElse(null);
            }

            @Override
            public void listResources(@NotNull String namespace, @NotNull String path, // Could not load outer class - annotation placement on inner may be incorrect
             @NotNull PackResources.ResourceOutput resourceOutput) {
                resourceManager.m_214160_(path, rl -> rl.m_135827_().equals(namespace)).forEach((rl, resources) -> resources.forEach(resource -> resourceOutput.accept(rl, () -> ((Resource)resource).m_215507_())));
            }

            @Override
            @NotNull
            public Set<String> getNamespaces() {
                return resourceManager.m_7187_();
            }
        };
        this.reset(context);
        Map<ResourceLocation, TexSource> sources = this.getSources(context, resourceManager);
        sources.forEach((rl, texSource) -> {
            TexSourceDataHolder dataHolder = new TexSourceDataHolder();
            dataHolder.put(TouchedTextureTracker.class, new TouchedTextureTracker());
            IoSupplier<NativeImage> imageSupplier = texSource.getSupplier(dataHolder, context);
            output.m_260840_(rl, () -> {
                try {
                    TextureMetaGenerator generator;
                    IoSupplier<InputStream> supplier;
                    if (imageSupplier == null) {
                        throw new IOException("No image supplier");
                    }
                    NativeImage image = (NativeImage)imageSupplier.m_247737_();
                    TouchedTextureTracker tracker = dataHolder.get(TouchedTextureTracker.class);
                    AnimationMetadataSection section = AnimationMetadataSection.f_119012_;
                    if (tracker != null && tracker.getTouchedTextures().size() >= 1 && (supplier = (generator = new TextureMetaGenerator.Builder().withSources(tracker.getTouchedTextures()).withOutputLocation((ResourceLocation)rl).build()).get(new ResourceLocation(rl.m_135827_(), "textures/" + rl.m_135815_() + ".png.mcmeta"), context)) != null) {
                        try (InputStreamReader reader = new InputStreamReader((InputStream)supplier.m_247737_());){
                            JsonObject json = (JsonObject)DynamicAssetGenerator.GSON.fromJson((Reader)reader, JsonObject.class);
                            if (json.has("animation")) {
                                JsonObject animation = GsonHelper.m_13930_((JsonObject)json, (String)"animation");
                                section = AnimationMetadataSection.f_119011_.m_6322_(animation);
                            }
                        }
                        catch (JsonParseException | IOException e) {
                            DynamicAssetGenerator.LOGGER.warn("Failed to generate texture meta for sprite source type " + this.getLocation() + " at " + rl + ": ", e);
                        }
                    }
                    FrameSize frameSize = new FrameSize(image.m_84982_(), image.m_85084_());
                    if (section != AnimationMetadataSection.f_119012_) {
                        frameSize = section.m_245821_(image.m_84982_(), image.m_85084_());
                    }
                    return new SpriteContents(rl, frameSize, image, section);
                }
                catch (IOException e) {
                    DynamicAssetGenerator.LOGGER.error("Failed to generate texture for sprite source type " + this.getLocation() + " at " + rl + ": ", (Throwable)e);
                    return null;
                }
            });
        });
    }

    @NotNull
    default public SpriteSourceType m_260850_() {
        return (SpriteSourceType)SpriteSourcesAccessor.getTypes().get((Object)this.getLocation());
    }
}

