/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client;

import com.google.common.collect.ImmutableList;
import dev.lukebemish.dynamicassetgenerator.api.compat.InvisibleResourceProvider;
import dev.lukebemish.dynamicassetgenerator.impl.platform.Services;
import dev.lukebemish.dynamicassetgenerator.impl.util.InvisibleProviderUtils;
import dev.lukebemish.dynamicassetgenerator.mixin.PackRepositoryMixin;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ClientPrePackRepository {
    private static List<? extends PackResources> resources = new ArrayList<PackResources>();

    @ApiStatus.Internal
    public static void resetResources() {
        resources = null;
    }

    public static List<? extends PackResources> getResources() {
        if (resources == null || resources.isEmpty()) {
            for (InvisibleResourceProvider provider : InvisibleProviderUtils.INVISIBLE_RESOURCE_PROVIDERS) {
                provider.reset(PackType.CLIENT_RESOURCES);
            }
            resources = (List)Stream.concat(Services.DEGROUPER.unpackPacks((List)((PackRepositoryMixin)Minecraft.m_91087_().m_91099_()).getSelected().stream().filter(p -> !p.m_10446_().startsWith("dynamic_asset_generator:")).map(Pack::m_10445_).filter(p -> !p.m_5542_().startsWith("dynamic_asset_generator:")).collect(ImmutableList.toImmutableList())).stream(), InvisibleProviderUtils.INVISIBLE_RESOURCE_PROVIDERS.stream().map(InvisibleProviderUtils::constructPlaceholderResourcesFromProvider)).collect(ImmutableList.toImmutableList());
        }
        return resources;
    }

    public static InputStream getResource(ResourceLocation rl) throws IOException {
        IoSupplier resource = null;
        for (PackResources packResources : ClientPrePackRepository.getResources()) {
            IoSupplier supplier;
            if (packResources.m_5542_().startsWith("dynamic_asset_generator:") || (supplier = packResources.m_214146_(PackType.CLIENT_RESOURCES, rl)) == null) continue;
            resource = supplier;
        }
        if (resource != null) {
            return (InputStream)resource.m_247737_();
        }
        throw new IOException("Could not find asset in pre-load: " + rl.toString());
    }

    public static Stream<InputStream> getResources(ResourceLocation rl) throws IOException {
        ArrayList<InputStream> out = new ArrayList<InputStream>();
        for (PackResources packResources : ClientPrePackRepository.getResources()) {
            IoSupplier supplier;
            if (packResources.m_5542_().startsWith("dynamic_asset_generator:") || (supplier = packResources.m_214146_(PackType.CLIENT_RESOURCES, rl)) == null) continue;
            out.add((InputStream)supplier.m_247737_());
        }
        if (!out.isEmpty()) {
            return out.stream();
        }
        throw new IOException("Could not find asset in pre-load: " + rl.toString());
    }
}

