/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.cache;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.RecordBuilder;
import dev.lukebemish.dynamicassetgenerator.api.cache.CacheMetaDynamicOps;
import dev.lukebemish.dynamicassetgenerator.api.cache.DataConsumer;

public class CacheMetaCodec<A, D>
implements Codec<A> {
    private final Codec<A> wrapped;
    private final DataConsumer<D, A> dataConsumer;
    private final String cacheKey;
    private final Class<? super D> dataClass;

    private CacheMetaCodec(Codec<A> wrapped, DataConsumer<D, A> dataConsumer, String cacheKey, Class<? super D> dataClass) {
        this.wrapped = wrapped;
        this.dataConsumer = dataConsumer;
        this.cacheKey = cacheKey;
        this.dataClass = dataClass;
    }

    public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T input) {
        return this.wrapped.decode(ops, input);
    }

    public <T> DataResult<T> encode(A input, DynamicOps<T> ops, T prefix) {
        CacheMetaDynamicOps cacheOps;
        D opsData;
        DataResult result = this.wrapped.encode(input, ops, prefix);
        if (ops instanceof CacheMetaDynamicOps && (opsData = (cacheOps = (CacheMetaDynamicOps)ops).getData(this.dataClass)) != null) {
            DataResult metadata = this.dataConsumer.encode(ops, opsData, input);
            if (metadata.result().isEmpty()) {
                return metadata;
            }
            return result.flatMap(t -> {
                if (ops.getMap(t).result().isPresent()) {
                    return ops.mergeToMap(t, ops.createString(this.cacheKey), metadata.result().get());
                }
                RecordBuilder builder = ops.mapBuilder();
                builder.add(ops.createString(this.cacheKey), metadata.result().get());
                builder.add("value", t);
                return builder.build(ops.empty());
            });
        }
        return result;
    }

    public static <A, D> Codec<A> of(Codec<A> wrapped, DataConsumer<D, A> dataConsumer, String cacheKey, Class<D> dataClass) {
        return new CacheMetaCodec<A, D>(wrapped, dataConsumer, cacheKey, dataClass);
    }
}

