/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api;

import com.google.common.collect.ImmutableList;
import dev.lukebemish.dynamicassetgenerator.api.compat.InvisibleResourceProvider;
import dev.lukebemish.dynamicassetgenerator.impl.util.InvisibleProviderUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ServerPrePackRepository {
    private static List<PackResources> resources = new ArrayList<PackResources>();

    @ApiStatus.Internal
    public static void loadResources(List<PackResources> r) {
        for (InvisibleResourceProvider provider : InvisibleProviderUtils.INVISIBLE_RESOURCE_PROVIDERS) {
            provider.reset(PackType.SERVER_DATA);
        }
        resources = (List)Stream.concat(r.stream().filter(p -> !p.m_5542_().startsWith("dynamic_asset_generator:")), InvisibleProviderUtils.INVISIBLE_RESOURCE_PROVIDERS.stream().map(InvisibleProviderUtils::constructPlaceholderResourcesFromProvider)).collect(ImmutableList.toImmutableList());
    }

    public static List<PackResources> getResources() {
        return resources;
    }

    public static InputStream getResource(ResourceLocation rl) throws IOException {
        IoSupplier resource = null;
        for (PackResources r : ServerPrePackRepository.getResources()) {
            IoSupplier supplier;
            if (r.m_5542_().startsWith("dynamic_asset_generator:") || (supplier = r.m_214146_(PackType.SERVER_DATA, rl)) == null) continue;
            resource = supplier;
        }
        if (resource != null) {
            return (InputStream)resource.m_247737_();
        }
        throw new IOException("Could not find data in pre-load: " + rl.toString());
    }

    public static Stream<InputStream> getResources(ResourceLocation rl) throws IOException {
        ArrayList<InputStream> out = new ArrayList<InputStream>();
        for (PackResources r : ServerPrePackRepository.getResources()) {
            IoSupplier supplier;
            if (r.m_5542_().startsWith("dynamic_asset_generator:") || (supplier = r.m_214146_(PackType.SERVER_DATA, rl)) == null) continue;
            out.add((InputStream)supplier.m_247737_());
        }
        if (!out.isEmpty()) {
            return out.stream();
        }
        throw new IOException("Could not find asset in pre-load: " + rl.toString());
    }
}

