/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.lukebemish.dynamicassetgenerator.api.PathAwareInputStreamSource;
import dev.lukebemish.dynamicassetgenerator.impl.CommonRegisters;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;

public interface ResourceGenerator
extends PathAwareInputStreamSource {
    public static final Codec<ResourceGenerator> CODEC = ExtraCodecs.m_184415_(() -> new Codec<Codec<? extends ResourceGenerator>>(){

        public <T> DataResult<Pair<Codec<? extends ResourceGenerator>, T>> decode(DynamicOps<T> ops, T input) {
            return ResourceLocation.f_135803_.decode(ops, input).flatMap(keyValuePair -> !CommonRegisters.RESOURCEGENERATORS.containsKey(keyValuePair.getFirst()) ? DataResult.error(() -> "Unknown dynamic resource generator type: " + keyValuePair.getFirst()) : DataResult.success((Object)keyValuePair.mapFirst(arg_0 -> CommonRegisters.RESOURCEGENERATORS.get(arg_0))));
        }

        public <T> DataResult<T> encode(Codec<? extends ResourceGenerator> input, DynamicOps<T> ops, T prefix) {
            ResourceLocation key = (ResourceLocation)CommonRegisters.RESOURCEGENERATORS.inverse().get(input);
            if (key == null) {
                return DataResult.error(() -> "Unregistered dynamic resource generator type: " + input);
            }
            Object toMerge = ops.createString(key.toString());
            return ops.mergeToPrimitive(prefix, toMerge);
        }
    }).dispatch(ResourceGenerator::codec, Function.identity());

    public static void register(ResourceLocation rl, Codec<? extends ResourceGenerator> reader) {
        CommonRegisters.RESOURCEGENERATORS.put((Object)rl, reader);
    }

    public Codec<? extends ResourceGenerator> codec();
}

