/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api;

import dev.lukebemish.dynamicassetgenerator.api.InputStreamSource;
import dev.lukebemish.dynamicassetgenerator.api.PathAwareInputStreamSource;
import dev.lukebemish.dynamicassetgenerator.api.Resettable;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.impl.Benchmarking;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.OldResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.impl.platform.Services;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class ResourceCache {
    protected static final String SOURCE_JSON_DIR = "dynamic_asset_generator";
    protected List<Supplier<? extends PathAwareInputStreamSource>> cache = new ArrayList<Supplier<? extends PathAwareInputStreamSource>>();
    private final List<Resettable> resetListeners = new ArrayList<Resettable>();
    private final ResourceLocation name;

    public static <T extends ResourceCache> T register(T cache, Pack.Position position) {
        DynamicAssetGenerator.registerCache(cache.getName(), cache, position);
        return cache;
    }

    public static <T extends ResourceCache> T register(T cache) {
        return ResourceCache.register(cache, Pack.Position.BOTTOM);
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public ResourceCache(ResourceLocation name) {
        this.name = name;
    }

    public Map<ResourceLocation, IoSupplier<InputStream>> getResources() {
        HashMap<ResourceLocation, IoSupplier<InputStream>> outputsSetup = new HashMap<ResourceLocation, IoSupplier<InputStream>>();
        this.cache.forEach(p -> {
            try {
                PathAwareInputStreamSource source = (PathAwareInputStreamSource)p.get();
                Set<ResourceLocation> rls = source.getLocations();
                rls.forEach(rl -> outputsSetup.put((ResourceLocation)rl, this.wrapSafeData((ResourceLocation)rl, source.get((ResourceLocation)rl, this.getContext()))));
            }
            catch (Throwable e) {
                DynamicAssetGenerator.LOGGER.error("Issue setting up PathAwareInputStreamSource:", e);
            }
        });
        Map<ResourceLocation, IoSupplier<InputStream>> outputs = outputsSetup;
        if (this.shouldCache()) {
            outputs = this.wrapCachedData(outputs);
        }
        return outputs;
    }

    @NotNull
    public ResourceGenerationContext getContext() {
        return OldResourceGenerationContext.make(this.name, this.getPackType());
    }

    public void planResetListener(Resettable listener) {
        this.resetListeners.add(listener);
    }

    public void reset() {
        this.resetListeners.forEach(Resettable::reset);
    }

    private IoSupplier<InputStream> wrapSafeData(ResourceLocation rl, IoSupplier<InputStream> supplier) {
        if (supplier == null) {
            return null;
        }
        IoSupplier output = () -> {
            try {
                return (InputStream)supplier.m_247737_();
            }
            catch (Throwable e) {
                DynamicAssetGenerator.LOGGER.error("Issue reading supplying resource {}:", (Object)rl, (Object)e);
                throw new IOException(e);
            }
        };
        if (DynamicAssetGenerator.TIME_RESOURCES) {
            return () -> {
                long startTime = System.nanoTime();
                InputStream result = (InputStream)output.m_247737_();
                long endTime = System.nanoTime();
                long duration = (endTime - startTime) / 1000L;
                Benchmarking.recordTime(this, rl, duration);
                return result;
            };
        }
        return output;
    }

    private Map<ResourceLocation, IoSupplier<InputStream>> wrapCachedData(Map<ResourceLocation, IoSupplier<InputStream>> map) {
        HashMap<ResourceLocation, IoSupplier<InputStream>> output = new HashMap<ResourceLocation, IoSupplier<InputStream>>();
        map.forEach((rl, supplier) -> {
            if (supplier == null) {
                return;
            }
            IoSupplier wrapped = () -> {
                try {
                    Path path = this.cachePath().resolve(rl.m_135827_()).resolve(rl.m_135815_());
                    if (!Files.exists(path.getParent(), new LinkOption[0])) {
                        Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    }
                    if (!Files.exists(path, new LinkOption[0])) {
                        InputStream stream = (InputStream)supplier.m_247737_();
                        Files.copy(stream, path, StandardCopyOption.REPLACE_EXISTING);
                    }
                    return new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
                }
                catch (IOException e) {
                    DynamicAssetGenerator.LOGGER.error("Could not cache resource...", (Throwable)e);
                    throw new IOException(e);
                }
            };
            output.put((ResourceLocation)rl, (IoSupplier<InputStream>)wrapped);
        });
        return output;
    }

    public abstract boolean shouldCache();

    public Path cachePath() {
        return Services.PLATFORM.getModDataFolder().resolve("cache").resolve(this.name.m_135827_()).resolve(this.name.m_135815_());
    }

    public void planSource(ResourceLocation rl, InputStreamSource source) {
        this.cache.add(ResourceCache.wrap(() -> Set.of(rl), source));
    }

    public void planSource(Supplier<Set<ResourceLocation>> locations, InputStreamSource source) {
        this.cache.add(ResourceCache.wrap(locations, source));
    }

    public void planSource(Set<ResourceLocation> locations, InputStreamSource source) {
        this.cache.add(ResourceCache.wrap(() -> locations, source));
    }

    public void planSource(PathAwareInputStreamSource source) {
        this.cache.add(() -> source);
        if (source instanceof Resettable) {
            Resettable resettable = (Resettable)((Object)source);
            this.planResetListener(resettable);
        }
    }

    public void planSource(Supplier<? extends PathAwareInputStreamSource> source) {
        this.cache.add(source);
    }

    @NotNull
    public abstract PackType getPackType();

    @ApiStatus.Internal
    public static Supplier<PathAwareInputStreamSource> wrap(final Supplier<Set<ResourceLocation>> rls, final InputStreamSource source) {
        return () -> new PathAwareInputStreamSource(){

            @Override
            @NotNull
            public Set<ResourceLocation> getLocations() {
                return (Set)rls.get();
            }

            @Override
            public IoSupplier<InputStream> get(ResourceLocation outRl, ResourceGenerationContext context) {
                return source.get(outRl, context);
            }
        };
    }
}

