/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.injection.mixins.sign_text_buffering;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.phys.Vec3;
import net.raphimc.immediatelyfast.ImmediatelyFast;
import net.raphimc.immediatelyfast.feature.sign_text_buffering.NoSetTextAnglesMatrixStack;
import net.raphimc.immediatelyfast.feature.sign_text_buffering.SignAtlasFramebuffer;
import net.raphimc.immediatelyfast.injection.interfaces.ISignText;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SignRenderer.class})
public abstract class MixinSignBlockEntityRenderer {
    @Shadow
    @Final
    private Font f_173633_;

    @Shadow
    abstract void m_278841_(BlockPos var1, SignText var2, PoseStack var3, MultiBufferSource var4, int var5, int var6, int var7, boolean var8);

    @Shadow
    protected abstract void m_278823_(PoseStack var1, boolean var2, Vec3 var3);

    @Shadow
    abstract Vec3 m_278725_();

    @Inject(method={"m_278841_(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/entity/SignText;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IIIZ)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderBufferedSignText(BlockPos pos, SignText signText, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int lineHeight, int lineWidth, boolean front, CallbackInfo ci) {
        if (matrices instanceof NoSetTextAnglesMatrixStack) {
            return;
        }
        ISignText iSignText = (ISignText)signText;
        if (!iSignText.immediatelyFast$shouldCache()) {
            return;
        }
        SignAtlasFramebuffer.Slot slot = (SignAtlasFramebuffer.Slot)ImmediatelyFast.signTextCache.slotCache.getIfPresent((Object)signText);
        if (slot == null) {
            int width = this.immediatelyFast$getTextWidth(signText, lineWidth);
            int height = 4 * lineHeight;
            if (width <= 0 || height <= 0) {
                iSignText.immediatelyFast$setShouldCache(false);
                return;
            }
            int padding = signText.m_276843_() ? 2 : 0;
            slot = ImmediatelyFast.signTextCache.signAtlasFramebuffer.findSlot(width + padding, height + padding);
            if (slot != null) {
                Matrix4f projectionMatrix = new Matrix4f().setOrtho(0.0f, 4096.0f, 4096.0f, 0.0f, -1000.0f, 1000.0f);
                RenderSystem.backupProjectionMatrix();
                RenderSystem.setProjectionMatrix((Matrix4f)projectionMatrix, (VertexSorting)VertexSorting.f_276633_);
                PoseStack modelViewMatrix = RenderSystem.getModelViewStack();
                modelViewMatrix.m_85836_();
                modelViewMatrix.m_166856_();
                RenderSystem.applyModelViewMatrix();
                float fogStart = RenderSystem.getShaderFogStart();
                FogRenderer.m_109017_();
                ImmediatelyFast.signTextCache.signAtlasFramebuffer.m_83947_(true);
                MultiBufferSource.BufferSource immediate = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                NoSetTextAnglesMatrixStack matrixStack = new NoSetTextAnglesMatrixStack();
                matrixStack.m_252880_(slot.x, slot.y, 0.0f);
                matrixStack.m_252880_((float)slot.width / 2.0f, (float)slot.height / 2.0f, 0.0f);
                this.m_278841_(Minecraft.m_91087_().f_91075_.m_20183_(), signText, matrixStack, (MultiBufferSource)immediate, light, lineHeight, lineWidth, front);
                immediate.m_109911_();
                Minecraft.m_91087_().m_91385_().m_83947_(true);
                RenderSystem.setShaderFogStart((float)fogStart);
                modelViewMatrix.m_85849_();
                RenderSystem.applyModelViewMatrix();
                RenderSystem.restoreProjectionMatrix();
                ImmediatelyFast.signTextCache.slotCache.put((Object)signText, (Object)slot);
            } else {
                ImmediatelyFast.LOGGER.warn("Failed to find a free slot for sign text (" + ImmediatelyFast.signTextCache.slotCache.size() + " sign texts in atlas). Falling back to immediate mode rendering.");
                iSignText.immediatelyFast$setShouldCache(false);
                return;
            }
        }
        float u1 = (float)slot.x / 4096.0f;
        float u2 = ((float)slot.x + (float)slot.width) / 4096.0f;
        float v1 = 1.0f - (float)slot.y / 4096.0f;
        float v2 = 1.0f - ((float)slot.y + (float)slot.height) / 4096.0f;
        if (signText.m_276843_()) {
            light = 0xF000F0;
        }
        matrices.m_85836_();
        this.m_278823_(matrices, front, this.m_278725_());
        matrices.m_252880_((float)(-slot.width) / 2.0f, (float)(-slot.height) / 2.0f, 0.0f);
        Matrix4f matrix4f = matrices.m_85850_().m_252922_();
        VertexConsumer vertexConsumer = vertexConsumers.m_6299_(ImmediatelyFast.signTextCache.renderLayer);
        vertexConsumer.m_252986_(matrix4f, 0.0f, (float)slot.height, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u1, v2).m_85969_(light).m_5752_();
        vertexConsumer.m_252986_(matrix4f, (float)slot.width, (float)slot.height, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u2, v2).m_85969_(light).m_5752_();
        vertexConsumer.m_252986_(matrix4f, (float)slot.width, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u2, v1).m_85969_(light).m_5752_();
        vertexConsumer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u1, v1).m_85969_(light).m_5752_();
        matrices.m_85849_();
        ci.cancel();
    }

    @Redirect(method={"m_278841_(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/entity/SignText;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IIIZ)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/blockentity/SignRenderer;m_278823_(Lcom/mojang/blaze3d/vertex/PoseStack;ZLnet/minecraft/world/phys/Vec3;)V"))
    private void dontSetTextAngles(SignRenderer instance, PoseStack matrices, boolean front, Vec3 translation) {
        if (matrices instanceof NoSetTextAnglesMatrixStack) {
            return;
        }
        this.m_278823_(matrices, front, translation);
    }

    @Unique
    private int immediatelyFast$getTextWidth(SignText signText, int lineWidth) {
        FormattedCharSequence[] orderedTexts = signText.m_277130_(Minecraft.m_91087_().m_167974_(), text -> {
            List list = this.f_173633_.m_92923_((FormattedText)text, lineWidth);
            return list.isEmpty() ? FormattedCharSequence.f_13691_ : (FormattedCharSequence)list.get(0);
        });
        int width = 0;
        for (FormattedCharSequence orderedText : orderedTexts) {
            width = Math.max(width, this.f_173633_.m_92724_(orderedText));
        }
        if (width % 2 != 0) {
            ++width;
        }
        return width;
    }
}

