/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import dev.corgitaco.ohthetreesyoullgrow.world.level.chunk.RandomTickScheduler;
import dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature.configurations.TreeFromStructureNBTConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

public class TreeFromStructureNBTFeature
extends Feature<TreeFromStructureNBTConfig> {
    private static final boolean DEBUG = false;

    public TreeFromStructureNBTFeature(Codec<TreeFromStructureNBTConfig> $$0) {
        super($$0);
    }

    public boolean m_142674_(FeaturePlaceContext<TreeFromStructureNBTConfig> featurePlaceContext) {
        TreeFromStructureNBTConfig config = (TreeFromStructureNBTConfig)featurePlaceContext.m_159778_();
        BlockStateProvider logProvider = config.logProvider();
        BlockStateProvider leavesProvider = config.leavesProvider();
        WorldGenLevel level = featurePlaceContext.m_159774_();
        StructureTemplateManager templateManager = level.m_6018_().m_215082_();
        ResourceLocation baseLocation = config.baseLocation();
        Optional baseTemplateOptional = templateManager.m_230407_(baseLocation);
        ResourceLocation canopyLocation = config.canopyLocation();
        Optional canopyTemplateOptional = templateManager.m_230407_(canopyLocation);
        if (baseTemplateOptional.isEmpty()) {
            throw TreeFromStructureNBTFeature.noTreePartPresent(baseLocation);
        }
        if (canopyTemplateOptional.isEmpty()) {
            throw TreeFromStructureNBTFeature.noTreePartPresent(canopyLocation);
        }
        StructureTemplate baseTemplate = (StructureTemplate)baseTemplateOptional.get();
        StructureTemplate canopyTemplate = (StructureTemplate)canopyTemplateOptional.get();
        List basePalettes = baseTemplate.f_74482_;
        List canopyPalettes = canopyTemplate.f_74482_;
        BlockPos origin = featurePlaceContext.m_159777_();
        RandomSource random = featurePlaceContext.m_225041_();
        StructurePlaceSettings placeSettings = new StructurePlaceSettings().m_74379_(Rotation.m_221990_((RandomSource)random));
        StructureTemplate.Palette trunkBasePalette = placeSettings.m_74387_(basePalettes, origin);
        StructureTemplate.Palette randomCanopyPalette = placeSettings.m_74387_(canopyPalettes, origin);
        List center = trunkBasePalette.m_74653_(Blocks.f_50041_);
        if (center.isEmpty()) {
            throw new IllegalArgumentException("No trunk central position was specified for structure NBT palette %s. Trunk central position is specified with white wool.".formatted(config.baseLocation()));
        }
        if (center.size() > 1) {
            throw new IllegalArgumentException("There cannot be more than one trunk central position for structure NBT palette %s. Trunk central position is specified with white wool.".formatted(config.baseLocation()));
        }
        BlockPos centerOffset = ((StructureTemplate.StructureBlockInfo)center.get(0)).f_74675_();
        centerOffset = new BlockPos(-centerOffset.m_123341_(), 0, -centerOffset.m_123343_());
        List<StructureTemplate.StructureBlockInfo> logs = TreeFromStructureNBTFeature.getStructureInfosInStructurePalletteFromBlockList(config.logTarget(), trunkBasePalette);
        List logBuilders = trunkBasePalette.m_74653_(Blocks.f_50108_);
        if (logBuilders.isEmpty()) {
            throw new UnsupportedOperationException(String.format("\"%s\" is missing log builders.", baseLocation));
        }
        int trunkLength = config.height().m_214085_(random);
        int maxTrunkBuildingDepth = config.maxLogDepth();
        for (StructureTemplate.StructureBlockInfo logBuilder : logBuilders) {
            BlockPos pos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, logBuilder, centerOffset, origin);
            if (TreeFromStructureNBTFeature.isOnGround(config.maxLogDepth(), level, pos, config.growableOn())) continue;
            return false;
        }
        HashMap<BlockPos, BlockState> leavePositions = new HashMap<BlockPos, BlockState>();
        HashMap<BlockPos, BlockState> logPositions = new HashMap<BlockPos, BlockState>();
        TreeFromStructureNBTFeature.fillTrunkPositions(logProvider, leavesProvider, config, level, random, origin, placeSettings, trunkBasePalette, centerOffset, logs, logBuilders, leavePositions, logPositions, maxTrunkBuildingDepth);
        if (!TreeFromStructureNBTFeature.fillCanopyPositions(trunkBasePalette.m_74653_(Blocks.f_50098_), config, level, random, placeSettings, centerOffset, origin, randomCanopyPalette, leavePositions, logPositions, trunkLength)) {
            return false;
        }
        if (TreeFromStructureNBTFeature.validateLogPositions(logPositions, config, level)) {
            return false;
        }
        TreeFromStructureNBTFeature.placeKnownLogPositions(logPositions, level);
        TreeFromStructureNBTFeature.placeKnownLeavePositions(leavePositions, level);
        TreeFromStructureNBTFeature.placeAdditional(config, level, origin, placeSettings, trunkBasePalette, centerOffset);
        TreeFromStructureNBTFeature.placeAdditional(config, level, origin, placeSettings, randomCanopyPalette, centerOffset);
        HashSet<BlockPos> decorationPositions = new HashSet<BlockPos>();
        TreeFromStructureNBTFeature.placeTreeDecorations(config.treeDecorators(), level, random, leavePositions.keySet(), logPositions.keySet(), decorationPositions);
        return true;
    }

    private static boolean fillCanopyPositions(List<StructureTemplate.StructureBlockInfo> canopyAnchor, TreeFromStructureNBTConfig config, WorldGenLevel level, RandomSource randomSource, StructurePlaceSettings placeSettings, BlockPos centerOffset, BlockPos origin, StructureTemplate.Palette randomCanopyPalette, Map<BlockPos, BlockState> leavePositions, Map<BlockPos, BlockState> logPositions, int trunkLength) {
        if (!canopyAnchor.isEmpty()) {
            if (canopyAnchor.size() > 1) {
                throw new IllegalArgumentException("There cannot be more than one central canopy position. Canopy central position is specified with yellow wool on the trunk palette.");
            }
            return TreeFromStructureNBTFeature.fillCanopyPositions(config.logProvider(), config.leavesProvider(), config, level, randomSource, TreeFromStructureNBTFeature.getModifiedPos(placeSettings, canopyAnchor.get(0), centerOffset, origin), placeSettings, randomCanopyPalette, leavePositions, logPositions, trunkLength);
        }
        return TreeFromStructureNBTFeature.fillCanopyPositions(config.logProvider(), config.leavesProvider(), config, level, randomSource, origin, placeSettings, randomCanopyPalette, leavePositions, logPositions, trunkLength);
    }

    private static boolean validateLogPositions(Map<BlockPos, BlockState> logPositions, TreeFromStructureNBTConfig config, WorldGenLevel level) {
        for (BlockPos trunkPosition : logPositions.keySet()) {
            if (config.leavesPlacementFilter().test((Object)level, (Object)trunkPosition)) continue;
            return true;
        }
        return false;
    }

    private static void placeKnownLogPositions(Map<BlockPos, BlockState> trunkPositions, WorldGenLevel level) {
        for (Map.Entry<BlockPos, BlockState> entry : trunkPositions.entrySet()) {
            BlockPos trunkPosition = entry.getKey();
            BlockState state = entry.getValue();
            level.m_7731_(trunkPosition, state, 2);
        }
    }

    private static void placeKnownLeavePositions(Map<BlockPos, BlockState> leavePositions, WorldGenLevel level) {
        ArrayList<Runnable> leavesPostApply = new ArrayList<Runnable>(leavePositions.size());
        for (Map.Entry<BlockPos, BlockState> entry : leavePositions.entrySet()) {
            BlockPos leavePosition = entry.getKey();
            BlockState state = entry.getValue();
            level.m_7731_(leavePosition, state, 2);
            if (!state.m_61138_((Property)LeavesBlock.f_54418_)) continue;
            Runnable postProcess = () -> {
                BlockState blockState = LeavesBlock.m_54435_((BlockState)state, (LevelAccessor)level, (BlockPos)leavePosition);
                if ((Integer)blockState.m_61143_((Property)LeavesBlock.f_54418_) < 7) {
                    if (blockState.m_61138_((Property)LeavesBlock.f_54419_)) {
                        blockState = (BlockState)blockState.m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(false));
                    }
                    level.m_7731_(leavePosition, blockState, 2);
                    level.m_186460_(leavePosition, blockState.m_60734_(), 0);
                } else {
                    level.m_7471_(leavePosition, false);
                    leavePositions.remove(leavePosition.m_7949_());
                }
            };
            leavesPostApply.add(postProcess);
        }
        leavesPostApply.forEach(Runnable::run);
    }

    public static void placeAdditional(TreeFromStructureNBTConfig config, WorldGenLevel level, BlockPos origin, StructurePlaceSettings placeSettings, StructureTemplate.Palette palette, BlockPos centerOffset) {
        List<StructureTemplate.StructureBlockInfo> additionalBlocks = TreeFromStructureNBTFeature.getStructureInfosInStructurePalletteFromBlockList(config.placeFromNBT(), palette);
        for (StructureTemplate.StructureBlockInfo additionalBlock : additionalBlocks) {
            BlockPos pos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, additionalBlock, centerOffset, origin);
            level.m_7731_(pos, additionalBlock.f_74676_(), 2);
            ((RandomTickScheduler)level.m_46865_(pos)).scheduleRandomTick(pos.m_7949_());
        }
    }

    public static void fillTrunkPositions(BlockStateProvider logProvider, BlockStateProvider leavesProvider, TreeFromStructureNBTConfig config, WorldGenLevel level, RandomSource randomSource, BlockPos origin, StructurePlaceSettings placeSettings, StructureTemplate.Palette trunkBasePalette, BlockPos centerOffset, List<StructureTemplate.StructureBlockInfo> logs, List<StructureTemplate.StructureBlockInfo> logBuilders, Map<BlockPos, BlockState> leavePositions, Map<BlockPos, BlockState> trunkPositions, int maxTrunkBuildingDepth) {
        TreeFromStructureNBTFeature.fillLogsUnder(logProvider, level, randomSource, origin, placeSettings, centerOffset, logBuilders, maxTrunkBuildingDepth, config.growableOn(), trunkPositions);
        TreeFromStructureNBTFeature.placeLogsWithRotation(logProvider, level, randomSource, origin, placeSettings, centerOffset, logs, trunkPositions);
        TreeFromStructureNBTFeature.placeLeavesWithCalculatedDistanceAndRotation(leavesProvider, level, origin, randomSource, placeSettings, TreeFromStructureNBTFeature.getStructureInfosInStructurePalletteFromBlockList(config.leavesTarget(), trunkBasePalette), leavePositions, centerOffset, config.leavesPlacementFilter());
    }

    public static boolean fillCanopyPositions(BlockStateProvider logProvider, BlockStateProvider leavesProvider, TreeFromStructureNBTConfig config, WorldGenLevel level, RandomSource randomSource, BlockPos origin, StructurePlaceSettings placeSettings, StructureTemplate.Palette randomCanopyPalette, Map<BlockPos, BlockState> leavePositions, Map<BlockPos, BlockState> trunkPositions, int trunkLength) {
        ArrayList<StructureTemplate.StructureBlockInfo> trunkFillers;
        List<StructureTemplate.StructureBlockInfo> leaves = TreeFromStructureNBTFeature.getStructureInfosInStructurePalletteFromBlockList(config.leavesTarget(), randomCanopyPalette);
        List<StructureTemplate.StructureBlockInfo> canopyLogs = TreeFromStructureNBTFeature.getStructureInfosInStructurePalletteFromBlockList(config.logTarget(), randomCanopyPalette);
        List canopyAnchor = randomCanopyPalette.m_74653_(Blocks.f_50041_);
        if (canopyAnchor.isEmpty()) {
            throw new IllegalArgumentException("No canopy anchor was specified for structure NBT palette %s. Canopy anchor is specified with white wool.".formatted(config.canopyLocation()));
        }
        if (canopyAnchor.size() > 1) {
            throw new IllegalArgumentException("There cannot be more than one canopy anchor for structure NBT palette %s. Canopy anchor is specified with white wool.".formatted(config.canopyLocation()));
        }
        StructureTemplate.StructureBlockInfo structureBlockInfo = (StructureTemplate.StructureBlockInfo)canopyAnchor.get(0);
        BlockPos canopyCenterOffset = structureBlockInfo.f_74675_();
        if (!TreeFromStructureNBTFeature.intersectTrunk(logProvider, level, randomSource, origin, placeSettings, canopyCenterOffset = new BlockPos(-canopyCenterOffset.m_123341_(), trunkLength, -canopyCenterOffset.m_123343_()), trunkFillers = new ArrayList<StructureTemplate.StructureBlockInfo>(randomCanopyPalette.m_74653_(Blocks.f_50108_)), trunkLength + 1, trunkPositions)) {
            return false;
        }
        TreeFromStructureNBTFeature.placeLogsWithRotation(logProvider, level, randomSource, origin, placeSettings, canopyCenterOffset, canopyLogs, trunkPositions);
        TreeFromStructureNBTFeature.placeLeavesWithCalculatedDistanceAndRotation(leavesProvider, level, origin, randomSource, placeSettings, leaves, leavePositions, canopyCenterOffset, config.leavesPlacementFilter());
        return true;
    }

    public static void placeLogsWithRotation(BlockStateProvider logProvider, WorldGenLevel level, RandomSource random, BlockPos origin, StructurePlaceSettings placeSettings, BlockPos centerOffset, List<StructureTemplate.StructureBlockInfo> logs, Map<BlockPos, BlockState> trunkPositions) {
        for (StructureTemplate.StructureBlockInfo trunk : logs) {
            BlockPos pos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, trunk, centerOffset, origin);
            trunkPositions.put(pos.m_7949_(), TreeFromStructureNBTFeature.getTransformedState(pos, logProvider.m_213972_(random, pos), trunk.f_74676_(), placeSettings.m_74404_(), level));
        }
    }

    public static void placeTreeDecorations(Iterable<TreeDecorator> treeDecorators, WorldGenLevel level, RandomSource random, Set<BlockPos> leavePositions, Set<BlockPos> trunkPositions, Set<BlockPos> decorationPositions) {
        for (TreeDecorator treeDecorator : treeDecorators) {
            treeDecorator.m_214187_(new TreeDecorator.Context((LevelSimulatedReader)level, (pos, state) -> {
                level.m_7731_(pos, state, 2);
                decorationPositions.add(pos.m_7949_());
            }, random, trunkPositions, leavePositions, trunkPositions));
        }
    }

    public static void placeLeavesWithCalculatedDistanceAndRotation(BlockStateProvider leavesProvider, WorldGenLevel level, BlockPos origin, RandomSource random, StructurePlaceSettings placeSettings, List<StructureTemplate.StructureBlockInfo> leaves, Map<BlockPos, BlockState> leavePositions, BlockPos canopyCenterOffset, BlockPredicate leavesPlacementFilter) {
        for (StructureTemplate.StructureBlockInfo leaf : leaves) {
            BlockPos modifiedPos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, leaf, canopyCenterOffset, origin);
            if (!leavesPlacementFilter.test((Object)level, (Object)modifiedPos)) continue;
            leavePositions.put(modifiedPos.m_7949_(), TreeFromStructureNBTFeature.getTransformedState(modifiedPos, leavesProvider.m_213972_(random, modifiedPos), leaf.f_74676_(), placeSettings.m_74404_(), level));
        }
    }

    public static void fillLogsUnder(BlockStateProvider logProvider, WorldGenLevel level, RandomSource random, BlockPos origin, StructurePlaceSettings placeSettings, BlockPos centerOffset, List<StructureTemplate.StructureBlockInfo> logBuilders, int maxTrunkBuildingDepth, BlockPredicate groundFilter, Map<BlockPos, BlockState> trunkPositions) {
        block0: for (StructureTemplate.StructureBlockInfo logBuilder : logBuilders) {
            BlockPos pos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, logBuilder, centerOffset, origin);
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
            for (int i = 0; i < maxTrunkBuildingDepth; ++i) {
                if (groundFilter.test((Object)level, (Object)mutableBlockPos) || level.m_8055_((BlockPos)mutableBlockPos).m_60713_(Blocks.f_50752_)) {
                    ((RandomTickScheduler)level.m_46865_((BlockPos)mutableBlockPos)).scheduleRandomTick(mutableBlockPos.m_7949_());
                    continue block0;
                }
                trunkPositions.put(mutableBlockPos.m_7949_(), TreeFromStructureNBTFeature.getTransformedState((BlockPos)mutableBlockPos, logProvider.m_213972_(random, (BlockPos)mutableBlockPos), logBuilder.f_74676_(), placeSettings.m_74404_(), level));
                mutableBlockPos.m_122173_(Direction.DOWN);
            }
        }
    }

    public static boolean intersectTrunk(BlockStateProvider logProvider, WorldGenLevel level, RandomSource random, BlockPos origin, StructurePlaceSettings placeSettings, BlockPos centerOffset, List<StructureTemplate.StructureBlockInfo> logBuilders, int maxTrunkBuildingDepth, Map<BlockPos, BlockState> trunkPositions) {
        for (StructureTemplate.StructureBlockInfo logBuilder : logBuilders) {
            BlockPos pos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, logBuilder, centerOffset, origin);
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
            for (int i = 0; i < maxTrunkBuildingDepth; ++i) {
                if (trunkPositions.containsKey(mutableBlockPos)) {
                    return true;
                }
                trunkPositions.put(mutableBlockPos.m_7949_(), TreeFromStructureNBTFeature.getTransformedState((BlockPos)mutableBlockPos, logProvider.m_213972_(random, (BlockPos)mutableBlockPos), logBuilder.f_74676_(), placeSettings.m_74404_(), level));
                mutableBlockPos.m_122173_(Direction.DOWN);
            }
        }
        return false;
    }

    @NotNull
    public static BlockState getTransformedState(BlockPos modifiedPos, BlockState state, BlockState nbtState, Rotation rotation, WorldGenLevel level) {
        for (Property property : state.m_61147_()) {
            if (!nbtState.m_61138_(property)) continue;
            Comparable value = nbtState.m_61143_(property);
            state = (BlockState)state.m_61124_(property, value);
        }
        if (state.m_61138_((Property)LeavesBlock.f_221367_)) {
            FluidState fluidState = level.m_6425_(modifiedPos);
            state = fluidState.m_192917_((Fluid)Fluids.f_76193_) && fluidState.m_76186_() >= 7 ? (BlockState)state.m_61124_((Property)LeavesBlock.f_221367_, (Comparable)Boolean.valueOf(true)) : (BlockState)state.m_61124_((Property)LeavesBlock.f_221367_, (Comparable)Boolean.valueOf(false));
        }
        state = state.m_60717_(rotation);
        return state;
    }

    public static boolean isOnGround(int maxLogDepth, WorldGenLevel level, BlockPos pos, BlockPredicate growableOn) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        for (int logDepth = 0; logDepth < maxLogDepth; ++logDepth) {
            mutableBlockPos.m_122173_(Direction.DOWN);
            if (!growableOn.test((Object)level, (Object)mutableBlockPos)) continue;
            return true;
        }
        return false;
    }

    public static BlockPos getModifiedPos(StructurePlaceSettings settings, StructureTemplate.StructureBlockInfo placing, BlockPos partCenter, BlockPos featureOrigin) {
        return StructureTemplate.m_74563_((StructurePlaceSettings)settings, (BlockPos)placing.f_74675_()).m_121955_((Vec3i)featureOrigin).m_121955_((Vec3i)StructureTemplate.m_74563_((StructurePlaceSettings)settings, (BlockPos)partCenter));
    }

    public static IllegalArgumentException noTreePartPresent(ResourceLocation location) {
        return new IllegalArgumentException(String.format("\"%s\" is not a valid tree part.", location));
    }

    public static List<StructureTemplate.StructureBlockInfo> getStructureInfosInStructurePalletteFromBlockList(Iterable<Block> blocks, StructureTemplate.Palette palette) {
        ArrayList<StructureTemplate.StructureBlockInfo> result = new ArrayList<StructureTemplate.StructureBlockInfo>();
        for (Block block : blocks) {
            result.addAll(palette.m_74653_(block));
        }
        return result;
    }
}

