/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.registry.util;

import architectspalette.core.event.CreativeModeTabEventHandler;
import architectspalette.core.event.ModelBakeEventHandler;
import architectspalette.core.model.BoardModel;
import architectspalette.core.model.util.SpriteShift;
import architectspalette.core.registry.APBlocks;
import architectspalette.core.registry.APItems;
import architectspalette.core.registry.util.StoneBlockSet;
import java.util.function.Supplier;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;

public class RegistryUtils {
    public static RegistryObject<Item> createItem(String name) {
        return RegistryUtils.createItem(name, APItems::resourceItem);
    }

    public static <I extends Item> RegistryObject<I> createItem(String name, Supplier<? extends I> supplier) {
        return RegistryUtils.createItem(name, supplier, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256968_);
    }

    public static <I extends Item> RegistryObject<I> createItem(String name, Supplier<? extends I> supplier, ResourceKey<CreativeModeTab> group) {
        RegistryObject item = APItems.ITEMS.register(name, supplier);
        CreativeModeTabEventHandler.assignItemToTab((Supplier<? extends ItemLike>)item, group);
        return item;
    }

    public static <B extends Block> RegistryObject<B> createBlock(String name, Supplier<? extends B> supplier) {
        return RegistryUtils.createBlock(name, supplier, CreativeModeTabs.f_256788_);
    }

    @SafeVarargs
    public static <B extends Block> RegistryObject<B> createBlock(String name, Supplier<? extends B> supplier, ResourceKey<CreativeModeTab> ... group) {
        RegistryObject block = APBlocks.BLOCKS.register(name, supplier);
        APItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        if (group != null) {
            CreativeModeTabEventHandler.assignItemToTab((Supplier<? extends ItemLike>)block, group);
        }
        return block;
    }

    public static <B extends Block> RegistryObject<B> createBlockNoItem(String name, Supplier<? extends B> supplier) {
        return APBlocks.BLOCKS.register(name, supplier);
    }

    public static <B extends Block> StoneBlockSet createBoardSet(String name, Supplier<? extends B> supplier) {
        StoneBlockSet boardSet = new StoneBlockSet(RegistryUtils.createBlock(name, supplier), StoneBlockSet.SetGroup.NO_WALLS).woodify();
        boardSet.forEachRegistryObject(obj -> ModelBakeEventHandler.register((RegistryObject<? extends Block>)obj, model -> new BoardModel((BakedModel)model, SpriteShift.getShift("block/" + name, "block/" + name + "_odd"))));
        return boardSet;
    }
}

