/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.registry.util;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraftforge.registries.RegistryObject;
import oshi.util.Memoizer;

public final class FeatureWrapper<T extends FeatureConfiguration> {
    private final String name;
    private final RegistryObject<Feature<T>> feature;
    private final T config;
    private final List<PlacementModifier> placement;
    private final Supplier<ConfiguredFeature<T, Feature<T>>> configuredFeatureSupplier;

    public FeatureWrapper(String name, RegistryObject<Feature<T>> feature, T config, List<PlacementModifier> placement) {
        this.name = name;
        this.feature = feature;
        this.config = config;
        this.placement = placement;
        this.configuredFeatureSupplier = Memoizer.memoize(() -> new ConfiguredFeature((Feature)this.feature().get(), config));
    }

    public String name() {
        return this.name;
    }

    public RegistryObject<Feature<T>> feature() {
        return this.feature;
    }

    public T config() {
        return this.config;
    }

    public List<PlacementModifier> placement() {
        return this.placement;
    }

    public ConfiguredFeature<T, Feature<T>> configuredFeature() {
        return this.configuredFeatureSupplier.get();
    }
}

