/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.event;

import architectspalette.core.model.BoardModel;
import architectspalette.core.model.HazardModel;
import architectspalette.core.model.SheetMetalModel;
import architectspalette.core.model.TileModel;
import architectspalette.core.model.util.SpriteShift;
import architectspalette.core.registry.APBlocks;
import architectspalette.core.registry.util.BlockNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="architects_palette", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ModelBakeEventHandler {
    private static final Map<Entry, Function<BakedModel, ? extends BakedModel>> customBlockModels = new HashMap<Entry, Function<BakedModel, ? extends BakedModel>>();

    @SubscribeEvent
    public static void onModelBake(ModelEvent.ModifyBakingResult event) {
        Map modelRegistry = event.getModels();
        ModelBakeEventHandler.register(APBlocks.UNOBTANIUM_BLOCK, TileModel::new);
        ModelBakeEventHandler.register(APBlocks.HAZARD_BLOCK.getObject(), HazardModel::new);
        ModelBakeEventHandler.register(APBlocks.SHEET_METAL.getObject(), model -> new SheetMetalModel((BakedModel)model, SpriteShift.getShift("block/sheet_metal_block", "block/sheet_metal_block_ct")));
        ModelBakeEventHandler.register(APBlocks.SHEET_METAL.getChild(BlockNode.BlockType.WALL), model -> new SheetMetalModel((BakedModel)model, SpriteShift.getShift("block/sheet_metal_block", "block/sheet_metal_block_ct")));
        for (BlockNode board : APBlocks.boards) {
            RegistryObject<Block> wall = board.getChild(BlockNode.BlockType.WALL);
            SpriteShift shift = SpriteShift.getShift("block/" + board.getName(), "block/" + board.getName() + "_odd");
            ModelBakeEventHandler.register(wall, model -> new BoardModel((BakedModel)model, shift));
        }
        customBlockModels.forEach((entry, factory) -> ModelBakeEventHandler.swapModels((Map<ResourceLocation, BakedModel>)modelRegistry, ModelBakeEventHandler.getAllBlockStateModelLocations(entry), factory));
    }

    public static void registerBoardModel(Supplier<Block> supplier, ResourceLocation blockToRegister, ResourceLocation baseBoardBlock) {
        ResourceLocation inBlockFolder = new ResourceLocation(baseBoardBlock.m_135827_(), "block/" + baseBoardBlock.m_135815_());
        ResourceLocation odd = new ResourceLocation(inBlockFolder.m_135827_(), inBlockFolder.m_135815_() + "_odd");
        ModelBakeEventHandler.register(supplier, blockToRegister, model -> new BoardModel((BakedModel)model, SpriteShift.getShift(inBlockFolder, odd)));
    }

    private static <T extends BakedModel> void swapModels(Map<ResourceLocation, BakedModel> modelRegistry, List<ModelResourceLocation> locations, Function<BakedModel, T> modelFactory) {
        locations.forEach(location -> ModelBakeEventHandler.swapModels(modelRegistry, location, modelFactory));
    }

    private static <T extends BakedModel> void swapModels(Map<ResourceLocation, BakedModel> modelRegistry, ModelResourceLocation location, Function<BakedModel, T> modelFactory) {
        modelRegistry.put((ResourceLocation)location, (BakedModel)modelFactory.apply(modelRegistry.get(location)));
    }

    private static List<ModelResourceLocation> getAllBlockStateModelLocations(Entry entry) {
        return ModelBakeEventHandler.getAllBlockStateModelLocations(entry.getBlock(), entry.getResourceLocation());
    }

    private static List<ModelResourceLocation> getAllBlockStateModelLocations(Block block, ResourceLocation resourceLocation) {
        ArrayList<ModelResourceLocation> models = new ArrayList<ModelResourceLocation>();
        block.m_49965_().m_61056_().forEach(state -> models.add(BlockModelShaper.m_110889_((ResourceLocation)resourceLocation, (BlockState)state)));
        return models;
    }

    public static <T extends BakedModel> void register(RegistryObject<? extends Block> registryObject, Function<BakedModel, T> modelFactory) {
        ModelBakeEventHandler.register(registryObject, registryObject.getId(), modelFactory);
    }

    public static <T extends BakedModel> void register(Supplier<? extends Block> blockSupplier, ResourceLocation resourceLocation, Function<BakedModel, T> modelFactory) {
        customBlockModels.put(new Entry(resourceLocation, blockSupplier), modelFactory);
    }

    private static class Entry {
        private final ResourceLocation resourceLocation;
        private final Supplier<? extends Block> block;

        public Entry(ResourceLocation resourceLocation, Supplier<? extends Block> block) {
            this.resourceLocation = resourceLocation;
            this.block = block;
        }

        public Block getBlock() {
            return this.block.get();
        }

        public ResourceLocation getResourceLocation() {
            return this.resourceLocation;
        }
    }
}

