/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.compat;

import architectspalette.compat.WarpingRecipeCategory;
import architectspalette.content.blocks.BigBrickBlock;
import architectspalette.content.blocks.CageLanternBlock;
import architectspalette.core.crafting.WarpingRecipe;
import architectspalette.core.registry.APBlocks;
import architectspalette.core.registry.util.BlockNode;
import architectspalette.core.registry.util.StoneBlockSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation PLUGIN_ID = new ResourceLocation("architects_palette", "jei_plugin");
    public static final RecipeType<WarpingRecipe> WARPING = RecipeType.create((String)"architects_palette", (String)"warping", WarpingRecipe.class);

    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new WarpingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(WARPING, Minecraft.m_91087_().f_91073_.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)WarpingRecipe.TYPE));
        JEIPlugin.builder().add(APBlocks.CHISELED_ABYSSALINE_BRICKS, APBlocks.CHISELED_HADALINE_BRICKS).registerInfo(registration, "chiseled_chargeable");
        JEIPlugin.builder().add(APBlocks.ABYSSALINE, APBlocks.ABYSSALINE_PILLAR, APBlocks.ABYSSALINE_LAMP_BLOCK, APBlocks.ABYSSALINE_PLATING).add(APBlocks.ABYSSALINE_BRICKS, APBlocks.ABYSSALINE_TILES).add(APBlocks.HADALINE, APBlocks.HADALINE_PILLAR, APBlocks.HADALINE_LAMP_BLOCK, APBlocks.HADALINE_PLATING).add(APBlocks.HADALINE_BRICKS, APBlocks.HADALINE_TILES).registerInfo(registration, "chargeable");
        JEIPlugin.builder().add(APBlocks.PLACID_ACACIA_TOTEM, APBlocks.GRINNING_ACACIA_TOTEM, APBlocks.SHOCKED_ACACIA_TOTEM, APBlocks.BLANK_ACACIA_TOTEM).registerInfo(registration, "totem_carving");
        JEIPlugin.builder().add(APBlocks.FLINT_BLOCK, APBlocks.FLINT_PILLAR).add(APBlocks.FLINT_TILES).registerInfo(registration, "flint_damage");
        JEIPlugin.builder().add(APBlocks.MOONSTONE, APBlocks.SUNSTONE).registerInfo(registration, "celestial_stones");
        JEIPlugin.builder().add(APBlocks.NETHER_BRASS, APBlocks.CUT_NETHER_BRASS, APBlocks.SMOOTH_NETHER_BRASS).add(APBlocks.NETHER_BRASS_PILLAR).registerInfo(registration, "nether_brass");
        JEIPlugin.builder().add(block -> block instanceof BigBrickBlock).registerInfo(registration, "heavy_bricks");
        JEIPlugin.builder().add(block -> block instanceof CageLanternBlock).registerInfo(registration, "cage_lanterns");
        JEIPlugin.builder().add(APBlocks.WARDSTONE, APBlocks.WARDSTONE_BRICKS).add(APBlocks.WARDSTONE_PILLAR, APBlocks.CHISELED_WARDSTONE, APBlocks.WARDSTONE_LAMP).registerInfo(registration, "wardstone");
    }

    private static void addItemInfo(IRecipeRegistration register, RegistryObject<? extends ItemLike> item, String infoString) {
        JEIPlugin.addItemInfo(register, (ItemLike)item.get(), infoString);
    }

    private static void addItemInfo(IRecipeRegistration register, StoneBlockSet stoneSet, String infoString) {
        stoneSet.forEach(block -> JEIPlugin.addItemInfo(register, (ItemLike)block, infoString));
    }

    private static void addItemInfo(IRecipeRegistration register, ItemLike item, String infoString) {
        register.addIngredientInfo((Object)new ItemStack(item), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)("architects_palette.info." + infoString))});
    }

    private static BlockListBuilder builder() {
        return new BlockListBuilder();
    }

    private static class BlockListBuilder {
        private final List<Block> blocks = new ArrayList<Block>();

        private BlockListBuilder() {
        }

        private BlockListBuilder add(BlockNode ... nodes) {
            for (BlockNode node : nodes) {
                node.forEach(n -> this.blocks.add(n.get()));
            }
            return this;
        }

        private BlockListBuilder add(StoneBlockSet ... sets) {
            for (StoneBlockSet set : sets) {
                set.forEach(this.blocks::add);
            }
            return this;
        }

        private BlockListBuilder add(Predicate<Block> filter) {
            for (RegistryObject entry : APBlocks.BLOCKS.getEntries()) {
                if (!filter.test((Block)entry.get())) continue;
                this.blocks.add((Block)entry.get());
            }
            return this;
        }

        @SafeVarargs
        private BlockListBuilder add(RegistryObject<? extends Block> ... blockList) {
            for (RegistryObject<? extends Block> block : blockList) {
                this.blocks.add((Block)block.get());
            }
            return this;
        }

        private void registerInfo(IRecipeRegistration register, String infoString) {
            register.addIngredientInfo(this.blocks.stream().map(ItemStack::new).toList(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)("architects_palette.info." + infoString))});
            this.blocks.clear();
        }
    }
}

