/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.events.server;

import com.mojang.brigadier.CommandDispatcher;
import dev.uncandango.alltheleaks.commands.ATLCommands;
import dev.uncandango.alltheleaks.events.common.ModEvent;
import dev.uncandango.alltheleaks.feature.common.mods.minecraft.MemoryMonitor;
import dev.uncandango.alltheleaks.report.ReportManager;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="alltheleaks", value={Dist.DEDICATED_SERVER})
public class GameBusEvent {
    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ReportManager.tick();
        }
    }

    @SubscribeEvent
    public static void registerServerCommands(RegisterCommandsEvent event) {
        ATLCommands.registerServerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        if (!ReportManager.isRegistered("min_memory_tracker")) {
            ReportManager.registerTask("min_memory_tracker", 1, MemoryMonitor.Statistics::evaluateMemory);
        }
    }

    @SubscribeEvent
    public static void printNonDaemonThreads(ServerStoppedEvent event) {
        Thread thread = new Thread(() -> {
            while (true) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    break;
                }
                Set<Thread> threads = Thread.getAllStackTraces().keySet();
                if (threads.isEmpty()) continue;
                if (ModEvent.reports > 0) {
                    System.out.println("AllTheLeaks: Seems like you crashed, it can cause stuck threads...");
                }
                System.out.println("AllTheLeaks: Listing stuck threads...");
                threads.stream().filter(t -> !t.isDaemon()).filter(t -> !t.getName().equals("DestroyJavaVM")).forEach(GameBusEvent::listThreads);
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    private static void listThreads(Thread thread) {
        System.out.println("Stuck thread: " + thread.getName());
    }
}

