/*
 * Decompiled with CFR 0.152.
 */
package net.jelly.sandworm_mod.worldevents;

import net.jelly.sandworm_mod.registry.common.WorldEventRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;

public class WormRippleWorldEvent
extends WorldEventInstance {
    public Vec3 position;
    public int lifetime = 30;
    public int scale = 2;
    public int in = 100;
    public int out = 30;

    public WormRippleWorldEvent() {
        super(WorldEventRegistry.WORM_RIPPLE);
    }

    public WormRippleWorldEvent spawnRipple(Vec3 pos) {
        this.position = pos;
        return this;
    }

    public void tick(Level level) {
        if (this.level == null) {
            return;
        }
        if (this.lifetime <= 0) {
            this.end(level);
        }
        if (!this.level.f_46443_ && this.lifetime > 0) {
            this.spawnSpiralParticles(this.position, this.lifetime);
        }
        --this.lifetime;
        super.tick(level);
    }

    private void spawnSpiralParticles(Vec3 pos, int lifetime) {
        for (int t = 0; t < 360; ++t) {
            if (t % 10 != 0) continue;
            int theta = t - 12 * lifetime;
            this.spawnParticle(new Vec3(pos.f_82479_ + (double)this.scale * ((double)lifetime / 30.0) * (double)t / 20.0 * Math.cos(Math.toRadians(theta)), pos.f_82480_, pos.f_82481_ + (double)this.scale * ((double)lifetime / 30.0) * (double)t / 20.0 * Math.sin(Math.toRadians(theta))));
        }
    }

    private void spawnParticle(Vec3 pos) {
        int heightDecrement = 0;
        BlockPos blockPos = BlockPos.m_274561_((double)pos.f_82479_, (double)(pos.f_82480_ - 1.0), (double)pos.f_82481_);
        BlockState blockState = this.level.m_8055_(blockPos);
        while (blockState.m_60795_()) {
            blockPos = BlockPos.m_274561_((double)pos.f_82479_, (double)(pos.f_82480_ - 1.0 - (double)heightDecrement), (double)pos.f_82481_);
            blockState = this.level.m_8055_(blockPos);
            if (++heightDecrement < 20) continue;
        }
        BlockParticleOption blockParticle = new BlockParticleOption(ParticleTypes.f_123794_, blockState);
        ((ServerLevel)this.level).m_8767_((ParticleOptions)blockParticle, pos.f_82479_, (double)(blockPos.m_123342_() + 1), pos.f_82481_, 1, 0.2, 0.0, 0.2, 0.0);
    }

    float lerp(float a, float b, float f) {
        return (float)((double)a * (1.0 - (double)f)) + b * f;
    }
}

