/*
 * Decompiled with CFR 0.152.
 */
package net.jelly.sandworm_mod.worldevents;

import net.jelly.sandworm_mod.registry.common.WorldEventRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;

public class WormBreachWorldEvent
extends WorldEventInstance {
    public Vec3 position;
    public boolean spawnedParticles;
    public int lifetime = 0;

    public WormBreachWorldEvent() {
        super(WorldEventRegistry.WORM_BREACH);
    }

    public WormBreachWorldEvent setPosition(Vec3 pos) {
        this.position = pos;
        return this;
    }

    public void tick(Level level) {
        if (this.level == null) {
            this.discarded = true;
            return;
        }
        ++this.lifetime;
        if (this.lifetime >= 480) {
            this.discarded = true;
            this.end(level);
        }
        super.tick(level);
    }

    public CompoundTag serializeNBT(CompoundTag tag) {
        tag.m_128347_("x", this.position.f_82479_);
        tag.m_128347_("y", this.position.f_82480_);
        tag.m_128347_("z", this.position.f_82481_);
        tag.m_128379_("spawnedparticles", this.spawnedParticles);
        tag.m_128347_("age", (double)this.lifetime);
        return super.serializeNBT(tag);
    }

    public WorldEventInstance deserializeNBT(CompoundTag tag) {
        this.position = new Vec3(tag.m_128459_("x"), tag.m_128459_("y"), tag.m_128459_("z"));
        this.spawnedParticles = tag.m_128471_("spawnedparticles");
        this.lifetime = tag.m_128451_("age");
        return super.deserializeNBT(tag);
    }

    public boolean isClientSynced() {
        return true;
    }
}

