/*
 * Decompiled with CFR 0.152.
 */
package net.jelly.sandworm_mod.worldevents;

import net.jelly.sandworm_mod.registry.common.WorldEventRegistry;
import net.jelly.sandworm_mod.vfx.SonicBoomFx;
import net.jelly.sandworm_mod.vfx.SonicBoomPostProcessor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;

public class SonicBoomWorldEvent
extends WorldEventInstance {
    private Entity followEntity;
    public int lifetime = 0;
    public SonicBoomFx fx;
    private int in = 10;
    private int sustain = 30;
    private int out = 30;
    private static float maxRadius = 1.0f;
    private static float maxSpeed = 50.0f;
    private static float maxMagnitude = 0.03f;
    private static float maxFrequency = 160.0f;

    public SonicBoomWorldEvent() {
        super(WorldEventRegistry.WORM_BREACH);
    }

    public SonicBoomWorldEvent spawnRipple(Entity followEntity) {
        this.followEntity = followEntity;
        if (followEntity == null) {
            this.discarded = true;
            return this;
        }
        this.fx = new SonicBoomFx(followEntity.m_20182_().m_252839_(), 0.0f, 0.0f, 0.0f, 0.0f);
        SonicBoomPostProcessor.INSTANCE.addFxInstance(this.fx);
        SonicBoomPostProcessor.INSTANCE.setActive(true);
        return this;
    }

    public void tick(Level level) {
        if (this.level == null) {
            return;
        }
        if (this.followEntity != null) {
            this.fx.center = this.followEntity.m_20182_().m_252839_();
        }
        if (this.lifetime <= this.in) {
            this.fx.radius = this.lerp(0.0f, maxRadius, (float)this.lifetime / (float)this.in);
            this.fx.speed = this.lerp(0.0f, maxSpeed, (float)this.lifetime / (float)this.in);
            this.fx.magnitude = this.lerp(0.0f, maxMagnitude, (float)this.lifetime / (float)this.in);
            this.fx.frequency = this.lerp(0.0f, maxFrequency, (float)this.lifetime / (float)this.in);
        } else if (this.lifetime >= this.in + this.sustain) {
            this.fx.magnitude = this.lerp(maxMagnitude, 0.0f, (float)this.lifetime / (float)(this.in + this.sustain + this.out));
        }
        ++this.lifetime;
        if (this.lifetime >= this.in + this.sustain + this.out) {
            this.fx.remove();
            this.end(level);
        }
    }

    float lerp(float a, float b, float f) {
        return (float)((double)a * (1.0 - (double)f)) + b * f;
    }
}

